/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.hibernate;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hibernate.ScrollableResults;

public class ScrollIterable<T>
implements Iterable<T> {
    private final ScrollableResults scrollableResults;
    private final Class<T> managedClass;

    public ScrollIterable(ScrollableResults scrollableResults, Class<T> managedClass) {
        this.scrollableResults = scrollableResults;
        this.managedClass = managedClass;
    }

    @Override
    public Iterator<T> iterator() {
        return new ScrollIterator();
    }

    private class ScrollIterator
    implements Iterator<T> {
        private boolean more;

        public ScrollIterator() {
            this.more = ScrollIterable.this.scrollableResults.first();
        }

        @Override
        public boolean hasNext() {
            return this.more;
        }

        @Override
        public T next() {
            if (!this.more) {
                throw new NoSuchElementException();
            }
            try {
                Object[] result;
                Object t = ScrollIterable.this.managedClass.cast(ScrollIterable.this.managedClass.isArray() && (result = ScrollIterable.this.scrollableResults.get()).length > 1 ? result : ScrollIterable.this.scrollableResults.get(0));
                return t;
            }
            finally {
                this.more = ScrollIterable.this.scrollableResults.next();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

