/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.jpa;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.persistence.orm.jpa.CriteriaWherePath;
import org.smallmind.persistence.query.NoneProduct;
import org.smallmind.persistence.query.Product;
import org.smallmind.persistence.query.SomeProduct;
import org.smallmind.persistence.query.Sort;
import org.smallmind.persistence.query.SortField;
import org.smallmind.persistence.query.Where;
import org.smallmind.persistence.query.WhereConjunction;
import org.smallmind.persistence.query.WhereCriterion;
import org.smallmind.persistence.query.WhereField;
import org.smallmind.persistence.query.WhereFieldTransformer;
import org.smallmind.persistence.query.WhereOperandTransformer;
import org.smallmind.persistence.query.WherePath;

public class CriteriaUtility {
    public static Product<Root<?>, Predicate> apply(CriteriaBuilder criteriaBuilder, Where where, WhereFieldTransformer<Root<?>, Path<?>> fieldTransformer) {
        return CriteriaUtility.apply(criteriaBuilder, where, fieldTransformer, WhereOperandTransformer.instance());
    }

    public static Product<Root<?>, Predicate> apply(CriteriaBuilder criteriaBuilder, Where where, WhereFieldTransformer<Root<?>, Path<?>> fieldTransformer, WhereOperandTransformer operandTransformer) {
        if (where == null) {
            return NoneProduct.none();
        }
        HashSet rootSet = new HashSet();
        Predicate predicate = CriteriaUtility.walkConjunction(criteriaBuilder, rootSet, where.getRootConjunction(), fieldTransformer, operandTransformer);
        if (predicate == null) {
            return NoneProduct.none();
        }
        return new SomeProduct(rootSet, predicate);
    }

    private static Predicate walkConjunction(CriteriaBuilder criteriaBuilder, Set<Root<?>> rootSet, WhereConjunction whereConjunction, WhereFieldTransformer<Root<?>, Path<?>> fieldTransformer, WhereOperandTransformer operandTransformer) {
        if (whereConjunction == null || whereConjunction.isEmpty()) {
            return null;
        }
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        WhereCriterion[] whereCriterionArray = whereConjunction.getCriteria();
        int n = whereCriterionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WhereCriterion whereCriterion = whereCriterionArray[n2];
            switch (whereCriterion.getCriterionType()) {
                case CONJUNCTION: {
                    Predicate walkedPredicate = CriteriaUtility.walkConjunction(criteriaBuilder, rootSet, (WhereConjunction)whereCriterion, fieldTransformer, operandTransformer);
                    if (walkedPredicate == null) break;
                    predicateList.add(walkedPredicate);
                    break;
                }
                case FIELD: {
                    predicateList.add(CriteriaUtility.walkField(criteriaBuilder, rootSet, (WhereField)whereCriterion, fieldTransformer, operandTransformer));
                    break;
                }
                default: {
                    throw new UnknownSwitchCaseException(whereCriterion.getCriterionType().name(), new Object[0]);
                }
            }
            ++n2;
        }
        if (predicateList.isEmpty()) {
            return null;
        }
        Predicate[] predicates = new Predicate[predicateList.size()];
        predicateList.toArray(predicates);
        switch (whereConjunction.getConjunctionType()) {
            case AND: {
                return criteriaBuilder.and(predicates);
            }
            case OR: {
                return criteriaBuilder.or(predicates);
            }
        }
        throw new UnknownSwitchCaseException(whereConjunction.getConjunctionType().name(), new Object[0]);
    }

    private static Predicate walkField(CriteriaBuilder criteriaBuilder, Set<Root<?>> rootSet, WhereField whereField, WhereFieldTransformer<Root<?>, Path<?>> fieldTransformer, WhereOperandTransformer operandTransformer) {
        Object fieldValue = operandTransformer.transform(whereField.getOperand());
        WherePath<Root<?>, Path<?>> wherePath = fieldTransformer.transform(whereField.getEntity(), whereField.getName());
        rootSet.add(((CriteriaWherePath)wherePath).getRoot());
        switch (whereField.getOperator()) {
            case LT: {
                return Date.class.equals(whereField.getOperand().getTargetClass()) ? criteriaBuilder.lessThan(wherePath.getPath(), (Comparable)((Date)fieldValue)) : criteriaBuilder.lt(wherePath.getPath(), (Number)fieldValue);
            }
            case LE: {
                return Date.class.equals(whereField.getOperand().getTargetClass()) ? criteriaBuilder.lessThanOrEqualTo(wherePath.getPath(), (Comparable)((Date)fieldValue)) : criteriaBuilder.le(wherePath.getPath(), (Number)fieldValue);
            }
            case EQ: {
                if (fieldValue == null) {
                    return criteriaBuilder.isNull((Expression)wherePath.getPath());
                }
                return criteriaBuilder.equal((Expression)wherePath.getPath(), fieldValue);
            }
            case NE: {
                if (fieldValue == null) {
                    return criteriaBuilder.isNotNull((Expression)wherePath.getPath());
                }
                return criteriaBuilder.notEqual((Expression)wherePath.getPath(), fieldValue);
            }
            case GE: {
                return Date.class.equals(whereField.getOperand().getTargetClass()) ? criteriaBuilder.greaterThanOrEqualTo(wherePath.getPath(), (Comparable)((Date)fieldValue)) : criteriaBuilder.ge(wherePath.getPath(), (Number)fieldValue);
            }
            case GT: {
                return Date.class.equals(whereField.getOperand().getTargetClass()) ? criteriaBuilder.greaterThan(wherePath.getPath(), (Comparable)((Date)fieldValue)) : criteriaBuilder.gt(wherePath.getPath(), (Number)fieldValue);
            }
            case LIKE: {
                return criteriaBuilder.like(wherePath.getPath(), (String)fieldValue);
            }
            case UNLIKE: {
                return criteriaBuilder.notLike(wherePath.getPath(), (String)fieldValue);
            }
            case IN: {
                return criteriaBuilder.in(wherePath.getPath()).in(new Object[]{fieldValue});
            }
        }
        throw new UnknownSwitchCaseException(whereField.getOperator().name(), new Object[0]);
    }

    public static Product<Root<?>, Order[]> apply(CriteriaBuilder criteriaBuilder, Sort sort, WhereFieldTransformer<Root<?>, Path<?>> fieldTransformer) {
        if (sort != null && !sort.isEmpty()) {
            HashSet rootSet = new HashSet();
            LinkedList<Order> orderList = new LinkedList<Order>();
            SortField[] sortFieldArray = sort.getFields();
            int n = sortFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                SortField sortField = sortFieldArray[n2];
                WherePath<Root<?>, Path<?>> wherePath = fieldTransformer.transform(sortField.getEntity(), sortField.getName());
                rootSet.add(((CriteriaWherePath)wherePath).getRoot());
                switch (sortField.getDirection()) {
                    case ASC: {
                        orderList.add(criteriaBuilder.asc((Expression)wherePath.getPath()));
                        break;
                    }
                    case DESC: {
                        orderList.add(criteriaBuilder.desc((Expression)wherePath.getPath()));
                        break;
                    }
                    default: {
                        throw new UnknownSwitchCaseException(sortField.getDirection().name(), new Object[0]);
                    }
                }
                ++n2;
            }
            Order[] orders = new Order[orderList.size()];
            orderList.toArray(orders);
            return new SomeProduct(rootSet, orders);
        }
        return NoneProduct.none();
    }
}

