/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.jpa;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.UpdateMode;
import org.smallmind.persistence.cache.VectoredDao;
import org.smallmind.persistence.orm.ORMDao;
import org.smallmind.persistence.orm.jpa.CriteriaDeleteDetails;
import org.smallmind.persistence.orm.jpa.CriteriaQueryDetails;
import org.smallmind.persistence.orm.jpa.CriteriaUpdateDetails;
import org.smallmind.persistence.orm.jpa.JPAProxySession;
import org.smallmind.persistence.orm.jpa.QueryDetails;

public abstract class JPADao<I extends Serializable & Comparable<I>, D extends Durable<I>>
extends ORMDao<I, D, EntityManagerFactory, EntityManager> {
    public JPADao(JPAProxySession proxySession) {
        this(proxySession, (VectoredDao<I, D>)null);
    }

    public JPADao(JPAProxySession proxySession, VectoredDao<I, D> vectoredDao) {
        super(proxySession, vectoredDao);
    }

    @Override
    public D get(Class<D> durableClass, I id) {
        if (id != null) {
            VectoredDao<I, Durable> vectoredDao = this.getVectoredDao();
            if (vectoredDao == null) {
                D durable = this.acquire(durableClass, id);
                if (durable != null) {
                    return durable;
                }
            } else {
                Durable<Object> durable = (Durable)vectoredDao.get(durableClass, id);
                if (durable != null) {
                    return (D)durable;
                }
                durable = this.acquire(durableClass, id);
                if (durable != null) {
                    return (D)vectoredDao.persist(durableClass, durable, UpdateMode.SOFT);
                }
            }
        }
        return null;
    }

    @Override
    public D acquire(Class<D> durableClass, I id) {
        return (D)(id == null ? null : (Durable)durableClass.cast(((EntityManager)this.getSession().getNativeSession()).find(durableClass, id)));
    }

    @Override
    public D persist(Class<D> durableClass, D durable) {
        if (durable != null) {
            Object persistentDurable;
            VectoredDao vectoredDao = this.getVectoredDao();
            if (((EntityManager)this.getSession().getNativeSession()).contains(durable)) {
                persistentDurable = durable;
            } else {
                persistentDurable = (Durable)this.getManagedClass().cast(((EntityManager)this.getSession().getNativeSession()).merge(durable));
                this.getSession().flush();
            }
            if (vectoredDao != null) {
                return vectoredDao.persist(durableClass, persistentDurable, UpdateMode.HARD);
            }
            return persistentDurable;
        }
        return null;
    }

    @Override
    public void delete(Class<D> durableClass, D durable) {
        if (durable != null) {
            VectoredDao vectoredDao = this.getVectoredDao();
            if (!((EntityManager)this.getSession().getNativeSession()).contains(durable)) {
                Durable persitentDurable = (Durable)((EntityManager)this.getSession().getNativeSession()).find(durableClass, durable.getId());
                if (persitentDurable != null) {
                    ((EntityManager)this.getSession().getNativeSession()).remove((Object)persitentDurable);
                    this.getSession().flush();
                }
            } else {
                ((EntityManager)this.getSession().getNativeSession()).remove(durable);
                this.getSession().flush();
            }
            if (vectoredDao != null) {
                vectoredDao.delete(durableClass, durable);
            }
        }
    }

    @Override
    public List<D> list() {
        return this.constructCriteriaQuery(this.getManagedClass(), new CriteriaQueryDetails<D>(){

            @Override
            public CriteriaQuery<D> completeCriteria(Class<D> criteriaClass, CriteriaBuilder criteriaBuilder) {
                CriteriaQuery query = criteriaBuilder.createQuery(JPADao.this.getManagedClass());
                Root root = query.from(JPADao.this.getManagedClass());
                return query.select((Selection)root);
            }
        }).getResultList();
    }

    @Override
    public List<D> list(int fetchSize) {
        return this.constructCriteriaQuery(this.getManagedClass(), new CriteriaQueryDetails<D>(){

            @Override
            public CriteriaQuery<D> completeCriteria(Class<D> criteriaClass, CriteriaBuilder criteriaBuilder) {
                CriteriaQuery query = criteriaBuilder.createQuery(JPADao.this.getManagedClass());
                Root root = query.from(JPADao.this.getManagedClass());
                return query.select((Selection)root);
            }
        }).setMaxResults(fetchSize).getResultList();
    }

    @Override
    public List<D> list(I greaterThan, int fetchSize) {
        return this.constructCriteriaQuery(this.getManagedClass(), new CriteriaQueryDetails<D>((Serializable)greaterThan){
            private final /* synthetic */ Serializable val$greaterThan;
            {
                this.val$greaterThan = serializable;
            }

            @Override
            public CriteriaQuery<D> completeCriteria(Class<D> criteriaClass, CriteriaBuilder criteriaBuilder) {
                CriteriaQuery query = criteriaBuilder.createQuery(JPADao.this.getManagedClass());
                Root root = query.from(JPADao.this.getManagedClass());
                return query.select((Selection)root).where((Expression)criteriaBuilder.gt((Expression)root.get("id"), (Number)this.val$greaterThan));
            }
        }).setMaxResults(fetchSize).getResultList();
    }

    @Override
    public List<D> list(final Collection<I> idCollection) {
        if (idCollection == null || idCollection.isEmpty()) {
            return Collections.emptyList();
        }
        return this.constructCriteriaQuery(this.getManagedClass(), new CriteriaQueryDetails<D>(){

            @Override
            public CriteriaQuery<D> completeCriteria(Class<D> criteriaClass, CriteriaBuilder criteriaBuilder) {
                CriteriaQuery query = criteriaBuilder.createQuery(JPADao.this.getManagedClass());
                Root root = query.from(JPADao.this.getManagedClass());
                return query.select((Selection)root).where((Expression)root.get("id").in(idCollection));
            }
        }).getResultList();
    }

    @Override
    public Iterable<D> scroll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<D> scroll(int fetchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<D> scrollById(I greaterThan, int fetchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public D detach(D object) {
        throw new UnsupportedOperationException("JPA has no explicit detached state");
    }

    public int deleteWithCriteria(CriteriaDeleteDetails<D> criteriaDeleteDetails) {
        return this.constructCriteriaDelete(this.getManagedClass(), criteriaDeleteDetails).executeUpdate();
    }

    public <T> int deleteWithCriteria(Class<T> criteriaType, CriteriaDeleteDetails<T> criteriaDeleteDetails) {
        return this.constructCriteriaDelete(criteriaType, criteriaDeleteDetails).executeUpdate();
    }

    public int executeWithQuery(QueryDetails queryDetails) {
        return this.constructQuery(queryDetails).executeUpdate();
    }

    public int executeWithCriteria(CriteriaUpdateDetails<D> criteriaUpdateDetails) {
        return this.constructCriteriaUpdate(this.getManagedClass(), criteriaUpdateDetails).executeUpdate();
    }

    public <T> int executeWithCriteria(Class<T> criteriaType, CriteriaUpdateDetails<T> criteriaUpdateDetails) {
        return this.constructCriteriaUpdate(criteriaType, criteriaUpdateDetails).executeUpdate();
    }

    public <T> T findByQuery(Class<T> returnType, QueryDetails queryDetails) {
        return returnType.cast(this.constructQuery(queryDetails).getSingleResult());
    }

    public D findByQuery(QueryDetails queryDetails) {
        return (D)((Durable)this.getManagedClass().cast(this.constructQuery(queryDetails).getSingleResult()));
    }

    public <T> T findByCriteria(Class<T> returnType, CriteriaQueryDetails<T> criteriaQueryDetails) {
        return returnType.cast(this.constructCriteriaQuery(returnType, criteriaQueryDetails).getSingleResult());
    }

    public D findByCriteria(CriteriaQueryDetails<D> criteriaQueryDetails) {
        return (D)((Durable)this.getManagedClass().cast(this.constructCriteriaQuery(this.getManagedClass(), criteriaQueryDetails).getSingleResult()));
    }

    public <T> List<T> listByQuery(Class<T> returnType, QueryDetails queryDetails) {
        return Collections.checkedList(this.constructQuery(queryDetails).getResultList(), returnType);
    }

    public List<D> listByQuery(QueryDetails queryDetails) {
        return Collections.checkedList(this.constructQuery(queryDetails).getResultList(), this.getManagedClass());
    }

    public <T> List<T> listByCriteria(Class<T> returnType, CriteriaQueryDetails<T> criteriaQueryDetails) {
        return Collections.checkedList(this.constructCriteriaQuery(returnType, criteriaQueryDetails).getResultList(), returnType);
    }

    public List<D> listByCriteria(CriteriaQueryDetails<D> criteriaQueryDetails) {
        return Collections.checkedList(this.constructCriteriaQuery(this.getManagedClass(), criteriaQueryDetails).getResultList(), this.getManagedClass());
    }

    public Query constructQuery(QueryDetails queryDetails) {
        return queryDetails.completeQuery(((EntityManager)this.getSession().getNativeSession()).createQuery(queryDetails.getQueryString()));
    }

    public <T> TypedQuery<T> constructCriteriaQuery(Class<T> criteriaClass, CriteriaQueryDetails<T> criteriaQueryDetails) {
        return ((EntityManager)this.getSession().getNativeSession()).createQuery(criteriaQueryDetails.completeCriteria(criteriaClass, ((EntityManager)this.getSession().getNativeSession()).getCriteriaBuilder()));
    }

    public <T> Query constructCriteriaUpdate(Class<T> criteriaClass, CriteriaUpdateDetails<T> criteriaUpdateDetails) {
        return ((EntityManager)this.getSession().getNativeSession()).createQuery(criteriaUpdateDetails.completeCriteria(criteriaClass, ((EntityManager)this.getSession().getNativeSession()).getCriteriaBuilder()));
    }

    public <T> Query constructCriteriaDelete(Class<T> criteriaClass, CriteriaDeleteDetails<T> criteriaDeleteDetails) {
        return ((EntityManager)this.getSession().getNativeSession()).createQuery(criteriaDeleteDetails.completeCriteria(criteriaClass, ((EntityManager)this.getSession().getNativeSession()).getCriteriaBuilder()));
    }
}

