/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.smallmind.persistence.orm.ProxySession;
import org.smallmind.persistence.orm.ProxyTransaction;
import org.smallmind.persistence.orm.SessionEnforcementException;
import org.smallmind.persistence.orm.aop.BoundarySet;
import org.smallmind.persistence.orm.aop.NonTransactionalState;
import org.smallmind.persistence.orm.aop.RollbackAwareBoundarySet;
import org.smallmind.persistence.orm.aop.TransactionalState;
import org.smallmind.persistence.orm.jpa.JPAProxyTransaction;

public class JPAProxySession
extends ProxySession<EntityManagerFactory, EntityManager> {
    private final ThreadLocal<EntityManager> managerThreadLocal = new ThreadLocal();
    private final ThreadLocal<JPAProxyTransaction> transactionThreadLocal = new ThreadLocal();
    private EntityManagerFactory entityManagerFactory;

    public JPAProxySession(String dataSourceType, String sessionSourceKey, EntityManagerFactory entityManagerFactory, boolean boundaryEnforced, boolean cacheEnabled) {
        super(dataSourceType, sessionSourceKey, boundaryEnforced, cacheEnabled);
        this.entityManagerFactory = entityManagerFactory;
    }

    @Override
    public JPAProxyTransaction beginTransaction() {
        JPAProxyTransaction proxyTransaction = this.transactionThreadLocal.get();
        if (proxyTransaction == null) {
            EntityManager entityManager = this.getEntityManager();
            proxyTransaction = this.transactionThreadLocal.get();
            if (proxyTransaction == null) {
                proxyTransaction = new JPAProxyTransaction(this, entityManager.getTransaction());
                this.transactionThreadLocal.set(proxyTransaction);
            }
        }
        return proxyTransaction;
    }

    @Override
    public ProxyTransaction currentTransaction() {
        return this.transactionThreadLocal.get();
    }

    @Override
    public void flush() {
        this.getEntityManager().flush();
    }

    @Override
    public void clear() {
        this.getEntityManager().clear();
    }

    @Override
    public boolean isClosed() {
        EntityManager entityManager = this.managerThreadLocal.get();
        return entityManager == null || !entityManager.isOpen();
    }

    @Override
    public EntityManagerFactory getNativeSessionFactory() {
        return this.entityManagerFactory;
    }

    @Override
    public EntityManager getNativeSession() {
        return this.getEntityManager();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EntityManager getEntityManager() {
        EntityManager entityManager;
        do {
            if ((entityManager = this.managerThreadLocal.get()) == null) {
                entityManager = this.entityManagerFactory.createEntityManager();
                this.managerThreadLocal.set(entityManager);
                RollbackAwareBoundarySet<ProxyTransaction> transactionSet = TransactionalState.obtainBoundary(this);
                if (transactionSet != null) {
                    try {
                        transactionSet.add(this.beginTransaction());
                    }
                    catch (Throwable throwable) {
                        this.close();
                        throw new SessionEnforcementException(throwable);
                    }
                } else {
                    BoundarySet<ProxySession> sessionSet = NonTransactionalState.obtainBoundary(this);
                    if (sessionSet != null) {
                        sessionSet.add(this);
                        continue;
                    }
                    if (!this.isBoundaryEnforced()) continue;
                    this.close();
                    throw new SessionEnforcementException("Session was requested outside of any boundary enforcement (@NonTransactional or @Transactional)", new Object[0]);
                }
            }
            if (entityManager.isOpen()) continue;
            entityManager = null;
            this.managerThreadLocal.set(null);
            this.transactionThreadLocal.set(null);
        } while (entityManager == null);
        return entityManager;
    }

    @Override
    public void close() {
        try {
            EntityManager entityManager = this.managerThreadLocal.get();
            if (entityManager != null) {
                entityManager.close();
            }
        }
        finally {
            this.managerThreadLocal.set(null);
            this.transactionThreadLocal.set(null);
        }
    }
}

