/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.morphia;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mongodb.morphia.query.MorphiaIterator;

public class AutoCloseMorphiaIterable<T>
implements Iterable<T>,
AutoCloseable {
    private AtomicBoolean closed = new AtomicBoolean(false);
    private MorphiaIterator<T, T> morphiaIterator;

    public AutoCloseMorphiaIterable(MorphiaIterator<T, T> morphiaIterator) {
        this.morphiaIterator = morphiaIterator;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.morphiaIterator.close();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new AutoCloseMorphiaIterator();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class AutoCloseMorphiaIterator
    implements Iterator<T> {
        private AutoCloseMorphiaIterator() {
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = AutoCloseMorphiaIterable.this.morphiaIterator.hasNext();
            if (!hasNext) {
                AutoCloseMorphiaIterable.this.close();
            }
            return hasNext;
        }

        @Override
        public T next() {
            return AutoCloseMorphiaIterable.this.morphiaIterator.next();
        }

        @Override
        public void remove() {
            AutoCloseMorphiaIterable.this.morphiaIterator.remove();
        }
    }
}

