/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.morphia;

import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.InsertOptions;
import org.mongodb.morphia.query.FindOptions;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.QueryImpl;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.UpdateMode;
import org.smallmind.persistence.cache.VectoredDao;
import org.smallmind.persistence.orm.ORMDao;
import org.smallmind.persistence.orm.morphia.AutoCloseMorphiaIterable;
import org.smallmind.persistence.orm.morphia.CountQueryDetails;
import org.smallmind.persistence.orm.morphia.DataStoreFactory;
import org.smallmind.persistence.orm.morphia.DeleteQueryDetails;
import org.smallmind.persistence.orm.morphia.FindQueryDetails;
import org.smallmind.persistence.orm.morphia.MorphiaDurable;
import org.smallmind.persistence.orm.morphia.MorphiaProxySession;
import org.smallmind.persistence.orm.morphia.QueryDetails;
import org.smallmind.persistence.orm.morphia.UpdateQueryDetails;

public class MorphiaDao<I extends Serializable & Comparable<I>, D extends MorphiaDurable<I, D>>
extends ORMDao<I, D, DataStoreFactory, Datastore> {
    public MorphiaDao(MorphiaProxySession proxySession) {
        this(proxySession, (VectoredDao<I, D>)null);
    }

    public MorphiaDao(MorphiaProxySession proxySession, VectoredDao<I, D> vectoredDao) {
        super(proxySession, vectoredDao);
    }

    @Override
    public D get(Class<D> durableClass, I id) {
        if (id != null) {
            VectoredDao<I, MorphiaDurable> vectoredDao = this.getVectoredDao();
            if (vectoredDao == null) {
                Durable durable = this.acquire((Class)durableClass, (Serializable)id);
                if (durable != null) {
                    return (D)durable;
                }
            } else {
                Durable durable = (MorphiaDurable)vectoredDao.get(durableClass, id);
                if (durable != null) {
                    return (D)durable;
                }
                durable = this.acquire((Class)durableClass, (Serializable)id);
                if (durable != null) {
                    return (D)vectoredDao.persist((Class<MorphiaDurable>)durableClass, (MorphiaDurable)durable, UpdateMode.SOFT);
                }
            }
        }
        return null;
    }

    @Override
    public D acquire(Class<D> durableClass, I id) {
        return (D)(id == null ? null : (MorphiaDurable)durableClass.cast(((Datastore)this.getSession().getNativeSession()).get(durableClass, id)));
    }

    @Override
    public List<D> list() {
        return ((Datastore)this.getSession().getNativeSession()).createQuery(this.getManagedClass()).asList();
    }

    @Override
    public List<D> list(int maxResults) {
        return ((Datastore)this.getSession().getNativeSession()).createQuery(this.getManagedClass()).asList(new FindOptions().limit(maxResults));
    }

    @Override
    public List<D> list(I greaterThan, int maxResults) {
        return ((Query)((Datastore)this.getSession().getNativeSession()).createQuery(this.getManagedClass()).field("_id").greaterThan(greaterThan)).order("_id").asList(new FindOptions().limit(maxResults));
    }

    @Override
    public List<D> list(Collection<I> idCollection) {
        return ((Query)((Datastore)this.getSession().getNativeSession()).createQuery(this.getManagedClass()).field("_id").in(idCollection)).asList();
    }

    @Override
    public Iterable<D> scroll() {
        return new AutoCloseMorphiaIterable(((Datastore)this.getSession().getNativeSession()).createQuery(this.getManagedClass()).fetch());
    }

    @Override
    public Iterable<D> scroll(int fetchSize) {
        return new AutoCloseMorphiaIterable(((Datastore)this.getSession().getNativeSession()).createQuery(this.getManagedClass()).fetch(new FindOptions().batchSize(fetchSize)));
    }

    @Override
    public Iterable<D> scrollById(I greaterThan, int fetchSize) {
        return new AutoCloseMorphiaIterable(((Query)((Datastore)this.getSession().getNativeSession()).createQuery(this.getManagedClass()).field("_id").greaterThan(greaterThan)).order("_id").fetch(new FindOptions().batchSize(fetchSize)));
    }

    @Override
    public long size() {
        return ((Datastore)this.getSession().getNativeSession()).createQuery(this.getManagedClass()).count();
    }

    @Override
    public D persist(Class<D> durableClass, D durable) {
        return this.persist(durableClass, durable, new InsertOptions().writeConcern(WriteConcern.JOURNALED));
    }

    public D persist(Class<D> durableClass, D durable, InsertOptions insertOptions) {
        if (durable != null) {
            VectoredDao vectoredDao = this.getVectoredDao();
            ((Datastore)this.getSession().getNativeSession()).save(durable, insertOptions);
            if (vectoredDao != null) {
                return (D)((MorphiaDurable)vectoredDao.persist(durableClass, durable, UpdateMode.HARD));
            }
            return durable;
        }
        return null;
    }

    @Override
    public void delete(Class<D> durableClass, D durable) {
        if (durable != null) {
            VectoredDao vectoredDao = this.getVectoredDao();
            ((Datastore)this.getSession().getNativeSession()).delete(durableClass, ((MorphiaDurable)durable).getId());
            if (vectoredDao != null) {
                vectoredDao.delete(durableClass, durable);
            }
        }
    }

    @Override
    public D detach(D object) {
        throw new UnsupportedOperationException("Morphia has no explicit detached state");
    }

    public long countByQuery(CountQueryDetails<D> queryDetails) {
        return this.constructQuery(queryDetails).count(queryDetails.getCountOptions());
    }

    public D findByQuery(FindQueryDetails<D> queryDetails) {
        return (D)((MorphiaDurable)this.constructQuery(queryDetails).get(queryDetails.getFindOptions()));
    }

    public List<D> listByQuery(FindQueryDetails<D> queryDetails) {
        return this.constructQuery(queryDetails).asList(queryDetails.getFindOptions());
    }

    public Iterable<D> scrollByQuery(FindQueryDetails<D> queryDetails) {
        return new AutoCloseMorphiaIterable(this.constructQuery(queryDetails).fetch(queryDetails.getFindOptions()));
    }

    public WriteResult deleteByQuery(DeleteQueryDetails<D> queryDetails) {
        return ((Datastore)this.getSession().getNativeSession()).delete(this.constructQuery(queryDetails), queryDetails.getDeleteOptions());
    }

    public UpdateResults updateByQuery(UpdateQueryDetails<D> updateQueryDetails) {
        Query query = ((Datastore)this.getSession().getNativeSession()).createQuery(this.getManagedClass());
        UpdateOperations update = ((Datastore)this.getSession().getNativeSession()).createUpdateOperations(this.getManagedClass());
        return ((Datastore)this.getSession().getNativeSession()).update(updateQueryDetails.completeQuery(query), updateQueryDetails.completeUpdates(update), updateQueryDetails.getUpdateOptions());
    }

    public Query<D> constructQuery(QueryDetails<D> queryDetails) {
        Query query = ((Datastore)this.getSession().getNativeSession()).createQuery(this.getManagedClass());
        return queryDetails.completeQuery(query);
    }

    public Query<D> constructRawQuery(String rawJson) {
        Query query = ((Datastore)this.getSession().getNativeSession()).createQuery(this.getManagedClass());
        ((QueryImpl)query).setQueryObject((DBObject)JSON.parse((String)rawJson));
        return query;
    }
}

