/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.morphia;

import java.util.Arrays;
import java.util.LinkedList;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.FieldEnd;
import org.mongodb.morphia.query.Query;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.persistence.orm.ORMOperationException;
import org.smallmind.persistence.query.Sort;
import org.smallmind.persistence.query.SortField;
import org.smallmind.persistence.query.Where;
import org.smallmind.persistence.query.WhereConjunction;
import org.smallmind.persistence.query.WhereCriterion;
import org.smallmind.persistence.query.WhereField;
import org.smallmind.persistence.query.WhereFieldTransformer;
import org.smallmind.persistence.query.WhereOperandTransformer;
import org.smallmind.persistence.query.WhereOperator;

public class QueryUtility {
    public static Query<?> apply(Query<?> query, Where where) {
        return QueryUtility.apply(query, where, null, WhereOperandTransformer.instance());
    }

    public static Query<?> apply(Query<?> query, Where where, WhereOperandTransformer operandTransformer) {
        return QueryUtility.apply(query, where, null, operandTransformer);
    }

    public static Query<?> apply(Query<?> query, Where where, WhereFieldTransformer<Void, Void> fieldTransformer) {
        return QueryUtility.apply(query, where, fieldTransformer, WhereOperandTransformer.instance());
    }

    public static Query<?> apply(Query<?> query, Where where, WhereFieldTransformer<Void, Void> fieldTransformer, WhereOperandTransformer operandTransformer) {
        if (where != null) {
            QueryUtility.walkConjunction(query, where.getRootConjunction(), fieldTransformer, operandTransformer);
        }
        return query;
    }

    private static Criteria walkConjunction(Query<?> query, WhereConjunction whereConjunction, WhereFieldTransformer<Void, Void> fieldTransformer, WhereOperandTransformer operandTransformer) {
        if (whereConjunction == null || whereConjunction.isEmpty()) {
            return null;
        }
        LinkedList<Criteria> criteriaList = new LinkedList<Criteria>();
        WhereCriterion[] whereCriterionArray = whereConjunction.getCriteria();
        int n = whereCriterionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WhereCriterion whereCriterion = whereCriterionArray[n2];
            switch (whereCriterion.getCriterionType()) {
                case CONJUNCTION: {
                    Criteria criteria = QueryUtility.walkConjunction(query, (WhereConjunction)whereCriterion, fieldTransformer, operandTransformer);
                    if (criteria == null) break;
                    criteriaList.add(criteria);
                    break;
                }
                case FIELD: {
                    Criteria criteria = QueryUtility.walkField(query, (WhereField)whereCriterion, fieldTransformer, operandTransformer);
                    if (criteria == null) break;
                    criteriaList.add(criteria);
                    break;
                }
                default: {
                    throw new UnknownSwitchCaseException(whereCriterion.getCriterionType().name(), new Object[0]);
                }
            }
            ++n2;
        }
        if (criteriaList.isEmpty()) {
            return null;
        }
        Criteria[] criteria = new Criteria[criteriaList.size()];
        criteriaList.toArray(criteria);
        switch (whereConjunction.getConjunctionType()) {
            case AND: {
                return query.and(criteria);
            }
            case OR: {
                return query.or(criteria);
            }
        }
        throw new UnknownSwitchCaseException(whereConjunction.getConjunctionType().name(), new Object[0]);
    }

    private static Criteria walkField(Query<?> query, WhereField whereField, WhereFieldTransformer<Void, Void> fieldTransformer, WhereOperandTransformer operandTransformer) {
        FieldEnd fieldEnd = query.criteria(fieldTransformer == null ? whereField.getName() : fieldTransformer.transform(whereField.getEntity(), whereField.getName()).getField());
        Object fieldValue = operandTransformer.transform(whereField.getOperand());
        switch (whereField.getOperator()) {
            case LT: {
                return (Criteria)fieldEnd.lessThan(fieldValue);
            }
            case LE: {
                return (Criteria)fieldEnd.lessThanOrEq(fieldValue);
            }
            case EQ: {
                Object equalValue = fieldValue;
                return equalValue == null ? (Criteria)fieldEnd.doesNotExist() : (Criteria)fieldEnd.equal(equalValue);
            }
            case NE: {
                Object notEqualValue = fieldValue;
                return notEqualValue == null ? (Criteria)fieldEnd.exists() : (Criteria)fieldEnd.notEqual(notEqualValue);
            }
            case GE: {
                return (Criteria)fieldEnd.greaterThanOrEq(fieldValue);
            }
            case GT: {
                return (Criteria)fieldEnd.greaterThan(fieldValue);
            }
            case LIKE: {
                Object likeValue = fieldValue;
                if (likeValue == null) {
                    return (Criteria)fieldEnd.doesNotExist();
                }
                if (!(likeValue instanceof String)) {
                    throw new ORMOperationException("The operation(%s) requires a String operand", WhereOperator.LIKE.name());
                }
                switch (((String)likeValue).length()) {
                    case 0: {
                        return (Criteria)fieldEnd.equal((Object)"");
                    }
                    case 1: {
                        return likeValue.equals("%") ? (Criteria)fieldEnd.exists() : (Criteria)fieldEnd.equal(likeValue);
                    }
                    case 2: {
                        return likeValue.equals("%%") ? (Criteria)fieldEnd.exists() : (((String)likeValue).charAt(0) == '%' ? (Criteria)fieldEnd.startsWith(((String)likeValue).substring(1)) : (((String)likeValue).charAt(1) == '%' ? (Criteria)fieldEnd.endsWith(((String)likeValue).substring(0, 1)) : (Criteria)fieldEnd.equal(likeValue)));
                    }
                }
                if (((String)likeValue).substring(1, ((String)likeValue).length() - 1).indexOf(37) >= 0) {
                    throw new ORMOperationException("The operation(%s) allows wildcards('%') only at the  start or end of the operand", WhereOperator.LIKE.name());
                }
                if (((String)likeValue).startsWith("%") && ((String)likeValue).endsWith("%")) {
                    return (Criteria)fieldEnd.contains(((String)likeValue).substring(1, ((String)likeValue).length() - 1));
                }
                if (((String)likeValue).startsWith("%")) {
                    return (Criteria)fieldEnd.startsWith(((String)likeValue).substring(1));
                }
                if (((String)likeValue).endsWith("%")) {
                    return (Criteria)fieldEnd.endsWith(((String)likeValue).substring(0, ((String)likeValue).length() - 1));
                }
                return (Criteria)fieldEnd.equal(likeValue);
            }
            case UNLIKE: {
                Object unlikeValue = fieldValue;
                if (unlikeValue == null) {
                    return (Criteria)fieldEnd.exists();
                }
                if (!(unlikeValue instanceof String)) {
                    throw new ORMOperationException("The operation(%s) requires a String operand", WhereOperator.UNLIKE.name());
                }
                switch (((String)unlikeValue).length()) {
                    case 0: {
                        return (Criteria)fieldEnd.notEqual((Object)"");
                    }
                    case 1: {
                        return unlikeValue.equals("%") ? (Criteria)fieldEnd.doesNotExist() : (Criteria)fieldEnd.notEqual(unlikeValue);
                    }
                    case 2: {
                        return unlikeValue.equals("%%") ? (Criteria)fieldEnd.doesNotExist() : (((String)unlikeValue).charAt(0) == '%' ? (Criteria)fieldEnd.not().startsWith(((String)unlikeValue).substring(1)) : (((String)unlikeValue).charAt(1) == '%' ? (Criteria)fieldEnd.not().endsWith(((String)unlikeValue).substring(0, 1)) : (Criteria)fieldEnd.notEqual(unlikeValue)));
                    }
                }
                if (((String)unlikeValue).substring(1, ((String)unlikeValue).length() - 1).indexOf(37) >= 0) {
                    throw new ORMOperationException("The operation(%s) allows wildcards('%') only at the  start or end of the operand", WhereOperator.UNLIKE.name());
                }
                if (((String)unlikeValue).startsWith("%") && ((String)unlikeValue).endsWith("%")) {
                    return (Criteria)fieldEnd.not().contains(((String)unlikeValue).substring(1, ((String)unlikeValue).length() - 1));
                }
                if (((String)unlikeValue).startsWith("%")) {
                    return (Criteria)fieldEnd.not().startsWith(((String)unlikeValue).substring(1));
                }
                if (((String)unlikeValue).endsWith("%")) {
                    return (Criteria)fieldEnd.not().endsWith(((String)unlikeValue).substring(0, ((String)unlikeValue).length() - 1));
                }
                return (Criteria)fieldEnd.notEqual(unlikeValue);
            }
            case IN: {
                return (Criteria)fieldEnd.in(Arrays.asList((Object[])fieldValue));
            }
        }
        throw new UnknownSwitchCaseException(whereField.getOperator().name(), new Object[0]);
    }

    public static Query<?> apply(Query<?> query, Sort sort) {
        return QueryUtility.apply(query, sort, null);
    }

    public static Query<?> apply(Query<?> query, Sort sort, WhereFieldTransformer<Void, Void> fieldTransformer) {
        if (sort != null && !sort.isEmpty()) {
            StringBuilder sortBuilder = new StringBuilder();
            SortField[] sortFieldArray = sort.getFields();
            int n = sortFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName;
                SortField sortField = sortFieldArray[n2];
                String string = fieldName = fieldTransformer == null ? sortField.getName() : fieldTransformer.transform(sortField.getEntity(), sortField.getName()).getField();
                if (sortBuilder.length() > 0) {
                    sortBuilder.append(", ");
                }
                switch (sortField.getDirection()) {
                    case ASC: {
                        sortBuilder.append(fieldName);
                        break;
                    }
                    case DESC: {
                        sortBuilder.append('-').append(fieldName);
                        break;
                    }
                    default: {
                        throw new UnknownSwitchCaseException(sortField.getDirection().name(), new Object[0]);
                    }
                }
                ++n2;
            }
            return query.order(sortBuilder.toString());
        }
        return query;
    }
}

