/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.querydsl;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.persistence.query.NoneProduct;
import org.smallmind.persistence.query.Product;
import org.smallmind.persistence.query.SomeProduct;
import org.smallmind.persistence.query.Sort;
import org.smallmind.persistence.query.SortField;
import org.smallmind.persistence.query.Where;
import org.smallmind.persistence.query.WhereConjunction;
import org.smallmind.persistence.query.WhereCriterion;
import org.smallmind.persistence.query.WhereField;
import org.smallmind.persistence.query.WhereFieldTransformer;
import org.smallmind.persistence.query.WhereOperandTransformer;
import org.smallmind.persistence.query.WherePath;

public class QUtility {
    public static Product<Path<?>, Predicate> apply(Where where, WhereFieldTransformer<Path<?>, Path<?>> fieldTransformer) {
        return QUtility.apply(where, fieldTransformer, WhereOperandTransformer.instance());
    }

    public static Product<Path<?>, Predicate> apply(Where where, WhereFieldTransformer<Path<?>, Path<?>> fieldTransformer, WhereOperandTransformer operandTransformer) {
        if (where == null) {
            return NoneProduct.none();
        }
        HashSet rootSet = new HashSet();
        Predicate predicate = QUtility.walkConjunction(rootSet, where.getRootConjunction(), fieldTransformer, operandTransformer);
        if (predicate == null) {
            return NoneProduct.none();
        }
        return new SomeProduct(rootSet, predicate);
    }

    private static Predicate walkConjunction(Set<Path<?>> rootSet, WhereConjunction whereConjunction, WhereFieldTransformer<Path<?>, Path<?>> fieldTransformer, WhereOperandTransformer operandTransformer) {
        if (whereConjunction == null || whereConjunction.isEmpty()) {
            return null;
        }
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        WhereCriterion[] whereCriterionArray = whereConjunction.getCriteria();
        int n = whereCriterionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WhereCriterion whereCriterion = whereCriterionArray[n2];
            switch (whereCriterion.getCriterionType()) {
                case CONJUNCTION: {
                    Predicate walkedPredicate = QUtility.walkConjunction(rootSet, (WhereConjunction)whereCriterion, fieldTransformer, operandTransformer);
                    if (walkedPredicate == null) break;
                    predicateList.add(walkedPredicate);
                    break;
                }
                case FIELD: {
                    Predicate walkedPredicate = QUtility.walkField(rootSet, (WhereField)whereCriterion, fieldTransformer, operandTransformer);
                    if (walkedPredicate == null) break;
                    predicateList.add(walkedPredicate);
                    break;
                }
                default: {
                    throw new UnknownSwitchCaseException(whereCriterion.getCriterionType().name(), new Object[0]);
                }
            }
            ++n2;
        }
        if (predicateList.isEmpty()) {
            return null;
        }
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        switch (whereConjunction.getConjunctionType()) {
            case AND: {
                for (Predicate predicate : predicateList) {
                    booleanBuilder.and(predicate);
                }
                return booleanBuilder;
            }
            case OR: {
                for (Predicate predicate : predicateList) {
                    booleanBuilder.or(predicate);
                }
                return booleanBuilder;
            }
        }
        throw new UnknownSwitchCaseException(whereConjunction.getConjunctionType().name(), new Object[0]);
    }

    private static Predicate walkField(Set<Path<?>> rootSet, WhereField whereField, WhereFieldTransformer<Path<?>, Path<?>> fieldTransformer, WhereOperandTransformer operandTransformer) {
        Object fieldValue = operandTransformer.transform(whereField.getOperand());
        WherePath<Path<?>, Path<?>> wherePath = fieldTransformer.transform(whereField.getEntity(), whereField.getName());
        rootSet.add(wherePath.getRoot());
        switch (whereField.getOperator()) {
            case LT: {
                return Expressions.predicate((Operator)Ops.LT, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case LE: {
                return Expressions.predicate((Operator)Ops.LOE, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case EQ: {
                if (fieldValue == null) {
                    return Expressions.predicate((Operator)Ops.IS_NULL, (Expression[])new Expression[]{(Expression)wherePath.getPath()});
                }
                return Expressions.predicate((Operator)Ops.EQ, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case NE: {
                if (fieldValue == null) {
                    return Expressions.predicate((Operator)Ops.IS_NOT_NULL, (Expression[])new Expression[]{(Expression)wherePath.getPath()});
                }
                return Expressions.predicate((Operator)Ops.NE, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case GE: {
                return Expressions.predicate((Operator)Ops.GOE, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case GT: {
                return Expressions.predicate((Operator)Ops.GT, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case LIKE: {
                return Expressions.predicate((Operator)Ops.LIKE, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case UNLIKE: {
                return Expressions.predicate((Operator)Ops.NOT, (Expression[])new Expression[]{Expressions.predicate((Operator)Ops.LIKE, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)})});
            }
            case IN: {
                int arrayLength = Array.getLength(fieldValue);
                if (arrayLength == 0) {
                    return null;
                }
                CollectionExpression collectionExpression = Expressions.collectionOperation(fieldValue.getClass().getComponentType(), (Operator)Ops.SINGLETON, (Expression[])new Expression[]{Expressions.constant((Object)Array.get(fieldValue, 0))});
                if (arrayLength > 1) {
                    int index = 1;
                    while (index < arrayLength) {
                        collectionExpression = Expressions.collectionOperation(fieldValue.getClass().getComponentType(), (Operator)Ops.LIST, (Expression[])new Expression[]{collectionExpression, Expressions.constant((Object)Array.get(fieldValue, index))});
                        ++index;
                    }
                }
                return Expressions.predicate((Operator)Ops.IN, (Expression[])new Expression[]{(Expression)wherePath.getPath(), collectionExpression});
            }
        }
        throw new UnknownSwitchCaseException(whereField.getOperator().name(), new Object[0]);
    }

    public static Product<Path<?>, OrderSpecifier[]> apply(Sort sort, WhereFieldTransformer<Path<?>, Path<?>> fieldTransformer) {
        if (sort != null && !sort.isEmpty()) {
            HashSet rootSet = new HashSet();
            LinkedList<OrderSpecifier> orderSpecifierList = new LinkedList<OrderSpecifier>();
            SortField[] sortFieldArray = sort.getFields();
            int n = sortFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                SortField sortField = sortFieldArray[n2];
                WherePath<Path<?>, Path<?>> wherePath = fieldTransformer.transform(sortField.getEntity(), sortField.getName());
                rootSet.add(wherePath.getRoot());
                switch (sortField.getDirection()) {
                    case ASC: {
                        orderSpecifierList.add(new OrderSpecifier(Order.ASC, (Expression)wherePath.getPath()));
                        break;
                    }
                    case DESC: {
                        orderSpecifierList.add(new OrderSpecifier(Order.DESC, (Expression)wherePath.getPath()));
                        break;
                    }
                    default: {
                        throw new UnknownSwitchCaseException(sortField.getDirection().name(), new Object[0]);
                    }
                }
                ++n2;
            }
            OrderSpecifier[] orderSpecifiers = new OrderSpecifier[orderSpecifierList.size()];
            orderSpecifierList.toArray(orderSpecifiers);
            return new SomeProduct(rootSet, orderSpecifiers);
        }
        return NoneProduct.none();
    }
}

