/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.querydsl.hibernate;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.jpa.hibernate.HibernateDeleteClause;
import com.querydsl.jpa.hibernate.HibernateQuery;
import com.querydsl.jpa.hibernate.HibernateUpdateClause;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.smallmind.nutsnbolts.util.IterableIterator;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.UpdateMode;
import org.smallmind.persistence.cache.VectoredDao;
import org.smallmind.persistence.orm.ORMDao;
import org.smallmind.persistence.orm.ProxySession;
import org.smallmind.persistence.orm.hibernate.HibernateDurable;
import org.smallmind.persistence.orm.querydsl.hibernate.HibernateDeleteDetails;
import org.smallmind.persistence.orm.querydsl.hibernate.HibernateQueryDetails;
import org.smallmind.persistence.orm.querydsl.hibernate.HibernateUpdateDetails;

public class QHibernateDao<I extends Serializable & Comparable<I>, D extends HibernateDurable<I, D>>
extends ORMDao<I, D, SessionFactory, Session> {
    public QHibernateDao(ProxySession<SessionFactory, Session> proxySession) {
        super(proxySession, null);
    }

    public QHibernateDao(ProxySession<SessionFactory, Session> proxySession, VectoredDao<I, D> vectoredDao) {
        super(proxySession, vectoredDao);
    }

    @Override
    public D get(Class<D> durableClass, I id) {
        if (id != null) {
            VectoredDao<I, HibernateDurable> vectoredDao = this.getVectoredDao();
            if (vectoredDao == null) {
                Durable durable = this.acquire((Class)durableClass, (Serializable)id);
                if (durable != null) {
                    return (D)durable;
                }
            } else {
                Durable durable = (HibernateDurable)vectoredDao.get(durableClass, id);
                if (durable != null) {
                    return (D)durable;
                }
                durable = this.acquire((Class)durableClass, (Serializable)id);
                if (durable != null) {
                    return (D)vectoredDao.persist((Class<HibernateDurable>)durableClass, (HibernateDurable)durable, UpdateMode.SOFT);
                }
            }
        }
        return null;
    }

    @Override
    public D acquire(Class<D> durableClass, I id) {
        return (D)(id == null ? null : (HibernateDurable)durableClass.cast(((Session)this.getSession().getNativeSession()).get(durableClass, id)));
    }

    @Override
    public D persist(Class<D> durableClass, D durable) {
        if (durable != null) {
            Object persistentDurable;
            VectoredDao vectoredDao = this.getVectoredDao();
            if (((Session)this.getSession().getNativeSession()).contains(durable)) {
                persistentDurable = durable;
            } else {
                persistentDurable = (HibernateDurable)this.getManagedClass().cast(((Session)this.getSession().getNativeSession()).merge(durable));
                this.getSession().flush();
            }
            if (vectoredDao != null) {
                return (D)((HibernateDurable)vectoredDao.persist(durableClass, persistentDurable, UpdateMode.HARD));
            }
            return persistentDurable;
        }
        return null;
    }

    @Override
    public void delete(Class<D> durableClass, D durable) {
        if (durable != null) {
            VectoredDao vectoredDao = this.getVectoredDao();
            if (!((Session)this.getSession().getNativeSession()).contains(durable)) {
                HibernateDurable persitentDurable = (HibernateDurable)((Session)this.getSession().getNativeSession()).get(durableClass, ((HibernateDurable)durable).getId());
                if (persitentDurable != null) {
                    ((Session)this.getSession().getNativeSession()).delete((Object)persitentDurable);
                    this.getSession().flush();
                }
            } else {
                ((Session)this.getSession().getNativeSession()).delete(durable);
                this.getSession().flush();
            }
            if (vectoredDao != null) {
                vectoredDao.delete(durableClass, durable);
            }
        }
    }

    @Override
    public D detach(D object) {
        throw new UnsupportedOperationException("Hibernate has no explicit detached state");
    }

    @Override
    public long size() {
        return this.countByQuery(new HibernateQueryDetails<D>(){

            @Override
            public HibernateQuery<D> completeQuery(HibernateQuery<D> query) {
                return (HibernateQuery)query.from((EntityPath)new EntityPathBase(QHibernateDao.this.getManagedClass(), "entity"));
            }
        });
    }

    @Override
    public List<D> list() {
        return this.listByQuery(new HibernateQueryDetails<D>(){

            @Override
            public HibernateQuery<D> completeQuery(HibernateQuery<D> query) {
                return (HibernateQuery)query.from((EntityPath)new EntityPathBase(QHibernateDao.this.getManagedClass(), "entity"));
            }
        });
    }

    @Override
    public List<D> list(final int fetchSize) {
        return this.listByQuery(new HibernateQueryDetails<D>(){

            @Override
            public HibernateQuery<D> completeQuery(HibernateQuery<D> query) {
                return (HibernateQuery)((HibernateQuery)query.from((EntityPath)new EntityPathBase(QHibernateDao.this.getManagedClass(), "entity"))).limit((long)fetchSize);
            }
        });
    }

    @Override
    public List<D> list(I greaterThan, int fetchSize) {
        return this.listByQuery(new HibernateQueryDetails<D>((Serializable)greaterThan, fetchSize){
            private final /* synthetic */ Serializable val$greaterThan;
            private final /* synthetic */ int val$fetchSize;
            {
                this.val$greaterThan = serializable;
                this.val$fetchSize = n;
            }

            @Override
            public HibernateQuery<D> completeQuery(HibernateQuery<D> query) {
                PathBuilder entityPath = new PathBuilder(QHibernateDao.this.getManagedClass(), "entity");
                SimplePath idPath = Expressions.path(QHibernateDao.this.getManagedClass(), (Path)entityPath, (String)"id");
                return (HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)query.from((EntityPath)entityPath)).where((Predicate)Expressions.predicate((Operator)Ops.GT, (Expression[])new Expression[]{idPath, Expressions.constant((Object)this.val$greaterThan)}))).orderBy(new OrderSpecifier(Order.ASC, (Expression)idPath))).limit((long)this.val$fetchSize);
            }
        });
    }

    @Override
    public List<D> list(final Collection<I> idCollection) {
        if (idCollection == null || idCollection.isEmpty()) {
            return Collections.emptyList();
        }
        return this.listByQuery(new HibernateQueryDetails<D>(){

            @Override
            public HibernateQuery<D> completeQuery(HibernateQuery<D> query) {
                PathBuilder entityPath = new PathBuilder(QHibernateDao.this.getManagedClass(), "entity");
                SimplePath idPath = Expressions.path(QHibernateDao.this.getManagedClass(), (Path)entityPath, (String)"id");
                Iterator idIterator = idCollection.iterator();
                CollectionExpression collectionExpression = Expressions.collectionOperation(QHibernateDao.this.getIdClass(), (Operator)Ops.SINGLETON, (Expression[])new Expression[]{Expressions.constant((Object)((Serializable)idIterator.next()))});
                while (idIterator.hasNext()) {
                    collectionExpression = Expressions.collectionOperation(QHibernateDao.this.getIdClass(), (Operator)Ops.LIST, (Expression[])new Expression[]{collectionExpression, Expressions.constant((Object)((Serializable)idIterator.next()))});
                }
                return (HibernateQuery)((HibernateQuery)query.from((EntityPath)entityPath)).where((Predicate)Expressions.predicate((Operator)Ops.IN, (Expression[])new Expression[]{idPath, collectionExpression}));
            }
        });
    }

    @Override
    public Iterable<D> scroll() {
        return this.scrollByQuery(new HibernateQueryDetails<D>(){

            @Override
            public HibernateQuery<D> completeQuery(HibernateQuery<D> query) {
                return (HibernateQuery)query.from((EntityPath)new EntityPathBase(QHibernateDao.this.getManagedClass(), "entity"));
            }
        });
    }

    @Override
    public Iterable<D> scroll(final int fetchSize) {
        return this.scrollByQuery(new HibernateQueryDetails<D>(){

            @Override
            public HibernateQuery<D> completeQuery(HibernateQuery<D> query) {
                return (HibernateQuery)((HibernateQuery)query.from((EntityPath)new EntityPathBase(QHibernateDao.this.getManagedClass(), "entity"))).limit((long)fetchSize);
            }
        });
    }

    @Override
    public Iterable<D> scrollById(I greaterThan, int fetchSize) {
        return this.scrollByQuery(new HibernateQueryDetails<D>((Serializable)greaterThan, fetchSize){
            private final /* synthetic */ Serializable val$greaterThan;
            private final /* synthetic */ int val$fetchSize;
            {
                this.val$greaterThan = serializable;
                this.val$fetchSize = n;
            }

            @Override
            public HibernateQuery<D> completeQuery(HibernateQuery<D> query) {
                PathBuilder entityPath = new PathBuilder(QHibernateDao.this.getManagedClass(), "entity");
                SimplePath idPath = Expressions.path(QHibernateDao.this.getManagedClass(), (Path)entityPath, (String)"id");
                return (HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)query.from((EntityPath)entityPath)).where((Predicate)Expressions.predicate((Operator)Ops.GT, (Expression[])new Expression[]{idPath, Expressions.constant((Object)this.val$greaterThan)}))).orderBy(new OrderSpecifier(Order.ASC, (Expression)idPath))).limit((long)this.val$fetchSize);
            }
        });
    }

    public <T> long countByQuery(HibernateQueryDetails<T> queryDetails) {
        return this.constructQuery(queryDetails).fetchCount();
    }

    public D findByQuery(HibernateQueryDetails<D> queryDetails) {
        return (D)((HibernateDurable)this.getManagedClass().cast(this.constructQuery(queryDetails).fetchOne()));
    }

    public <T> T findByQuery(Class<T> returnType, HibernateQueryDetails<T> queryDetails) {
        return returnType.cast(this.constructQuery(queryDetails).fetchOne());
    }

    public List<D> listByQuery(HibernateQueryDetails<D> queryDetails) {
        return Collections.checkedList(this.constructQuery(queryDetails).fetch(), this.getManagedClass());
    }

    public <T> List<T> listByQuery(Class<T> returnType, HibernateQueryDetails<T> queryDetails) {
        return Collections.checkedList(this.constructQuery(queryDetails).fetch(), returnType);
    }

    public <T> Iterable<T> scrollByQuery(HibernateQueryDetails<T> queryDetails) {
        return new IterableIterator((Iterator)this.constructQuery(queryDetails).iterate());
    }

    public Long updateWithQuery(HibernateUpdateDetails<D> updateDetails) {
        return this.constructUpdate(updateDetails).execute();
    }

    public Long deleteWithQuery(HibernateDeleteDetails<D> deleteDetails) {
        return this.constructDelete(deleteDetails).execute();
    }

    private <T> HibernateQuery<T> constructQuery(HibernateQueryDetails<T> queryDetails) {
        HibernateQuery query = new HibernateQuery((Session)this.getSession().getNativeSession());
        return queryDetails.completeQuery(query);
    }

    private <T> HibernateUpdateClause constructUpdate(HibernateUpdateDetails<T> updateDetails) {
        HibernateUpdateClause updateClause = new HibernateUpdateClause((Session)this.getSession().getNativeSession(), updateDetails.getEntityPath());
        return updateDetails.completeUpdate(updateClause);
    }

    private <T> HibernateDeleteClause constructDelete(HibernateDeleteDetails<T> deleteDetails) {
        HibernateDeleteClause deleteClause = new HibernateDeleteClause((Session)this.getSession().getNativeSession(), deleteDetails.getEntityPath());
        return deleteDetails.completeDelete(deleteClause);
    }
}

