/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.querydsl.jpa;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.smallmind.nutsnbolts.util.IterableIterator;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.UpdateMode;
import org.smallmind.persistence.cache.VectoredDao;
import org.smallmind.persistence.orm.ORMDao;
import org.smallmind.persistence.orm.ProxySession;
import org.smallmind.persistence.orm.jpa.JPADurable;
import org.smallmind.persistence.orm.querydsl.jpa.JPADeleteDetails;
import org.smallmind.persistence.orm.querydsl.jpa.JPAQueryDetails;
import org.smallmind.persistence.orm.querydsl.jpa.JPAUpdateDetails;

public class QJPADao<I extends Serializable & Comparable<I>, D extends JPADurable<I, D>>
extends ORMDao<I, D, EntityManagerFactory, EntityManager> {
    public QJPADao(ProxySession<EntityManagerFactory, EntityManager> proxySession) {
        super(proxySession, null);
    }

    public QJPADao(ProxySession<EntityManagerFactory, EntityManager> proxySession, VectoredDao<I, D> vectoredDao) {
        super(proxySession, vectoredDao);
    }

    @Override
    public D get(Class<D> durableClass, I id) {
        if (id != null) {
            VectoredDao<I, JPADurable> vectoredDao = this.getVectoredDao();
            if (vectoredDao == null) {
                Durable durable = this.acquire((Class)durableClass, (Serializable)id);
                if (durable != null) {
                    return (D)durable;
                }
            } else {
                Durable durable = (JPADurable)vectoredDao.get(durableClass, id);
                if (durable != null) {
                    return (D)durable;
                }
                durable = this.acquire((Class)durableClass, (Serializable)id);
                if (durable != null) {
                    return (D)vectoredDao.persist((Class<JPADurable>)durableClass, (JPADurable)durable, UpdateMode.SOFT);
                }
            }
        }
        return null;
    }

    @Override
    public D acquire(Class<D> durableClass, I id) {
        return (D)(id == null ? null : (JPADurable)durableClass.cast(((EntityManager)this.getSession().getNativeSession()).find(durableClass, id)));
    }

    @Override
    public D persist(Class<D> durableClass, D durable) {
        if (durable != null) {
            Object persistentDurable;
            VectoredDao vectoredDao = this.getVectoredDao();
            if (((EntityManager)this.getSession().getNativeSession()).contains(durable)) {
                persistentDurable = durable;
            } else {
                persistentDurable = (JPADurable)this.getManagedClass().cast(((EntityManager)this.getSession().getNativeSession()).merge(durable));
                this.getSession().flush();
            }
            if (vectoredDao != null) {
                return (D)((JPADurable)vectoredDao.persist(durableClass, persistentDurable, UpdateMode.HARD));
            }
            return persistentDurable;
        }
        return null;
    }

    @Override
    public void delete(Class<D> durableClass, D durable) {
        if (durable != null) {
            VectoredDao vectoredDao = this.getVectoredDao();
            if (!((EntityManager)this.getSession().getNativeSession()).contains(durable)) {
                Object persistedState = ((EntityManager)this.getSession().getNativeSession()).find(durable.getClass(), ((JPADurable)durable).getId());
                if (persistedState != null) {
                    ((EntityManager)this.getSession().getNativeSession()).remove(persistedState);
                    this.getSession().flush();
                }
            } else {
                ((EntityManager)this.getSession().getNativeSession()).remove(durable);
                this.getSession().flush();
            }
            if (vectoredDao != null) {
                vectoredDao.delete(durableClass, durable);
            }
        }
    }

    @Override
    public D detach(D object) {
        throw new UnsupportedOperationException("JPA has no explicit detached state");
    }

    @Override
    public long size() {
        return this.countByQuery(new JPAQueryDetails<D>(){

            @Override
            public JPAQuery<D> completeQuery(JPAQuery<D> query) {
                return (JPAQuery)query.from((EntityPath)new EntityPathBase(QJPADao.this.getManagedClass(), "entity"));
            }
        });
    }

    @Override
    public List<D> list() {
        return this.listByQuery(new JPAQueryDetails<D>(){

            @Override
            public JPAQuery<D> completeQuery(JPAQuery<D> query) {
                return (JPAQuery)query.from((EntityPath)new EntityPathBase(QJPADao.this.getManagedClass(), "entity"));
            }
        });
    }

    @Override
    public List<D> list(final int fetchSize) {
        return this.listByQuery(new JPAQueryDetails<D>(){

            @Override
            public JPAQuery<D> completeQuery(JPAQuery<D> query) {
                return (JPAQuery)((JPAQuery)query.from((EntityPath)new EntityPathBase(QJPADao.this.getManagedClass(), "entity"))).limit((long)fetchSize);
            }
        });
    }

    @Override
    public List<D> list(I greaterThan, int fetchSize) {
        return this.listByQuery(new JPAQueryDetails<D>((Serializable)greaterThan, fetchSize){
            private final /* synthetic */ Serializable val$greaterThan;
            private final /* synthetic */ int val$fetchSize;
            {
                this.val$greaterThan = serializable;
                this.val$fetchSize = n;
            }

            @Override
            public JPAQuery<D> completeQuery(JPAQuery<D> query) {
                PathBuilder entityPath = new PathBuilder(QJPADao.this.getManagedClass(), "entity");
                SimplePath idPath = Expressions.path(QJPADao.this.getManagedClass(), (Path)entityPath, (String)"id");
                return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)query.from((EntityPath)entityPath)).where((Predicate)Expressions.predicate((Operator)Ops.GT, (Expression[])new Expression[]{idPath, Expressions.constant((Object)this.val$greaterThan)}))).orderBy(new OrderSpecifier(Order.ASC, (Expression)idPath))).limit((long)this.val$fetchSize);
            }
        });
    }

    @Override
    public List<D> list(final Collection<I> idCollection) {
        if (idCollection == null || idCollection.isEmpty()) {
            return Collections.emptyList();
        }
        return this.listByQuery(new JPAQueryDetails<D>(){

            @Override
            public JPAQuery<D> completeQuery(JPAQuery<D> query) {
                PathBuilder entityPath = new PathBuilder(QJPADao.this.getManagedClass(), "entity");
                SimplePath idPath = Expressions.path(QJPADao.this.getManagedClass(), (Path)entityPath, (String)"id");
                Iterator idIterator = idCollection.iterator();
                CollectionExpression collectionExpression = Expressions.collectionOperation(QJPADao.this.getIdClass(), (Operator)Ops.SINGLETON, (Expression[])new Expression[]{Expressions.constant((Object)((Serializable)idIterator.next()))});
                while (idIterator.hasNext()) {
                    collectionExpression = Expressions.collectionOperation(QJPADao.this.getIdClass(), (Operator)Ops.LIST, (Expression[])new Expression[]{collectionExpression, Expressions.constant((Object)((Serializable)idIterator.next()))});
                }
                return (JPAQuery)((JPAQuery)query.from((EntityPath)entityPath)).where((Predicate)Expressions.predicate((Operator)Ops.IN, (Expression[])new Expression[]{idPath, collectionExpression}));
            }
        });
    }

    @Override
    public Iterable<D> scroll() {
        return this.scrollByQuery(new JPAQueryDetails<D>(){

            @Override
            public JPAQuery<D> completeQuery(JPAQuery<D> query) {
                return (JPAQuery)query.from((EntityPath)new EntityPathBase(QJPADao.this.getManagedClass(), "entity"));
            }
        });
    }

    @Override
    public Iterable<D> scroll(final int fetchSize) {
        return this.scrollByQuery(new JPAQueryDetails<D>(){

            @Override
            public JPAQuery<D> completeQuery(JPAQuery<D> query) {
                return (JPAQuery)((JPAQuery)query.from((EntityPath)new EntityPathBase(QJPADao.this.getManagedClass(), "entity"))).limit((long)fetchSize);
            }
        });
    }

    @Override
    public Iterable<D> scrollById(I greaterThan, int fetchSize) {
        return this.scrollByQuery(new JPAQueryDetails<D>((Serializable)greaterThan, fetchSize){
            private final /* synthetic */ Serializable val$greaterThan;
            private final /* synthetic */ int val$fetchSize;
            {
                this.val$greaterThan = serializable;
                this.val$fetchSize = n;
            }

            @Override
            public JPAQuery<D> completeQuery(JPAQuery<D> query) {
                PathBuilder entityPath = new PathBuilder(QJPADao.this.getManagedClass(), "entity");
                SimplePath idPath = Expressions.path(QJPADao.this.getManagedClass(), (Path)entityPath, (String)"id");
                return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)query.from((EntityPath)entityPath)).where((Predicate)Expressions.predicate((Operator)Ops.GT, (Expression[])new Expression[]{idPath, Expressions.constant((Object)this.val$greaterThan)}))).orderBy(new OrderSpecifier(Order.ASC, (Expression)idPath))).limit((long)this.val$fetchSize);
            }
        });
    }

    public <T> long countByQuery(JPAQueryDetails<T> queryDetails) {
        return this.constructQuery(queryDetails).fetchCount();
    }

    public D findByQuery(JPAQueryDetails<D> queryDetails) {
        return (D)((JPADurable)this.getManagedClass().cast(this.constructQuery(queryDetails).fetchOne()));
    }

    public <T> T findByQuery(Class<T> returnType, JPAQueryDetails<T> queryDetails) {
        return returnType.cast(this.constructQuery(queryDetails).fetchOne());
    }

    public List<D> listByQuery(JPAQueryDetails<D> queryDetails) {
        return Collections.checkedList(this.constructQuery(queryDetails).fetch(), this.getManagedClass());
    }

    public <T> List<T> listByQuery(Class<T> returnType, JPAQueryDetails<T> queryDetails) {
        return Collections.checkedList(this.constructQuery(queryDetails).fetch(), returnType);
    }

    public <T> Iterable<T> scrollByQuery(JPAQueryDetails<T> queryDetails) {
        return new IterableIterator((Iterator)this.constructQuery(queryDetails).iterate());
    }

    public Long updateWithQuery(JPAUpdateDetails<D> updateDetails) {
        return this.constructUpdate(updateDetails).execute();
    }

    public Long deleteWithQuery(JPADeleteDetails<D> deleteDetails) {
        return this.constructDelete(deleteDetails).execute();
    }

    private <T> JPAQuery<T> constructQuery(JPAQueryDetails<T> queryDetails) {
        JPAQuery query = new JPAQuery((EntityManager)this.getSession().getNativeSession());
        if (queryDetails.getEntityGraphSetting() != null) {
            query.setHint(queryDetails.getEntityGraphSetting().getHint().getKey(), (Object)((EntityManager)this.getSession().getNativeSession()).createEntityGraph(queryDetails.getEntityGraphSetting().getName()));
        }
        return queryDetails.completeQuery(query);
    }

    private <T> JPAUpdateClause constructUpdate(JPAUpdateDetails<T> updateDetails) {
        JPAUpdateClause updateClause = new JPAUpdateClause((EntityManager)this.getSession().getNativeSession(), updateDetails.getEntityPath());
        return updateDetails.completeUpdate(updateClause);
    }

    private <T> JPADeleteClause constructDelete(JPADeleteDetails<T> deleteDetails) {
        JPADeleteClause deleteClause = new JPADeleteClause((EntityManager)this.getSession().getNativeSession(), deleteDetails.getEntityPath());
        return deleteDetails.completeDelete(deleteClause);
    }
}

