/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.reflect;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.smallmind.persistence.orm.ProcessPriority;
import org.smallmind.persistence.orm.ProxyTransaction;
import org.smallmind.persistence.orm.ProxyTransactionException;
import org.smallmind.persistence.orm.TransactionEndState;
import org.smallmind.persistence.orm.reflect.DelayedInvocationPostProcess;

public class PostProcessInvocationHandler
implements Serializable,
InvocationHandler {
    private ProxyTransaction proxyTransaction;
    private TransactionEndState endState;
    private ProcessPriority priority;
    private Object proxyTarget;

    public PostProcessInvocationHandler(ProxyTransaction proxyTransaction, Object proxyTarget, TransactionEndState endState, ProcessPriority priority) {
        this.proxyTransaction = proxyTransaction;
        this.proxyTarget = proxyTarget;
        this.endState = endState;
        this.priority = priority;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new ProxyTransactionException("Attempt to post process a method(%s) of class(%s) with a non-void return type", method.getName(), this.proxyTarget.getClass().getName());
        }
        this.proxyTransaction.addPostProcess(new DelayedInvocationPostProcess(this.endState, this.priority, this.proxyTarget, method, args));
        return null;
    }
}

