/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.smallmind.persistence.orm.ProcessPriority;
import org.smallmind.persistence.orm.ProxyTransaction;
import org.smallmind.persistence.orm.ProxyTransactionException;
import org.smallmind.persistence.orm.TransactionEndState;
import org.smallmind.persistence.orm.aop.TransactionalState;
import org.smallmind.persistence.orm.reflect.PostProcessInvocationHandler;

public class PostProcessProxyFactory {
    public static Proxy generatePostProcessProxy(String sessionSourceKey, Class proxyInterface, Object target, TransactionEndState endState, ProcessPriority priority) {
        ProxyTransaction proxyTransaction = TransactionalState.currentTransaction(sessionSourceKey);
        if (proxyTransaction == null) {
            throw new ProxyTransactionException("No current transaction for the requested data source(%s)", sessionSourceKey);
        }
        return PostProcessProxyFactory.generatePostProcessProxy(proxyTransaction, proxyInterface, target, endState, priority);
    }

    public static Proxy generatePostProcessProxy(ProxyTransaction proxyTransaction, Class proxyInterface, Object target, TransactionEndState endState, ProcessPriority priority) {
        return (Proxy)Proxy.newProxyInstance(proxyInterface.getClassLoader(), new Class[]{proxyInterface}, (InvocationHandler)new PostProcessInvocationHandler(proxyTransaction, target, endState, priority));
    }
}

