/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.spring;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import org.smallmind.persistence.ManagedDao;
import org.smallmind.persistence.orm.MappedSubClasses;
import org.smallmind.persistence.orm.SessionSource;
import org.smallmind.persistence.spring.ManagedDaoSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public abstract class AbstractAnnotationSeekingBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final Class[] NO_CLASSES = new Class[0];
    private final HashMap<String, HashSet<Class>> annotatedClassMap = new HashMap();

    public abstract Class<? extends ManagedDao>[] getDaoImplementations();

    public abstract Class<? extends Annotation>[] getTargetAnnotations();

    public Class[] getAnnotatedClasses() {
        return this.getAnnotatedClasses(null);
    }

    public Class[] getAnnotatedClasses(String sessionSourceKey) {
        HashSet<Class> annotatedClassSet = this.annotatedClassMap.get(sessionSourceKey);
        if (annotatedClassSet == null) {
            return NO_CLASSES;
        }
        Class[] annotatedClasses = new Class[annotatedClassSet.size()];
        annotatedClassSet.toArray(annotatedClasses);
        return annotatedClasses;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        String[] stringArray = configurableListableBeanFactory.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            Class beanClass = configurableListableBeanFactory.getType(beanName);
            if (beanClass != null && this.isDaoImplementation(beanClass)) {
                HashSet<Class<Object>> annotatedClassSet;
                Class persistentClass = ManagedDaoSupport.findDurableClass(beanClass);
                if (persistentClass == null) {
                    throw new FatalBeanException("No inference of the Durable class for type(" + beanClass.getName() + ") was possible");
                }
                String sessionSourceKey = null;
                SessionSource dataSourceAnnotation = beanClass.getAnnotation(SessionSource.class);
                if (dataSourceAnnotation != null) {
                    sessionSourceKey = dataSourceAnnotation.value();
                }
                if ((annotatedClassSet = this.annotatedClassMap.get(sessionSourceKey)) == null) {
                    annotatedClassSet = new HashSet();
                    this.annotatedClassMap.put(sessionSourceKey, annotatedClassSet);
                }
                this.processClass(persistentClass, annotatedClassSet);
            }
            ++n2;
        }
    }

    private void processClass(Class<?> persistentClass, HashSet<Class> annotatedClassSet) {
        if (this.hasTargetAnnotation(persistentClass)) {
            annotatedClassSet.add(persistentClass);
            MappedSubClasses mappedSubClasses = persistentClass.getAnnotation(MappedSubClasses.class);
            if (mappedSubClasses != null) {
                Class[] classArray = mappedSubClasses.value();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class subclass = classArray[n2];
                    if (!persistentClass.isAssignableFrom(subclass)) {
                        throw new FatalBeanException("Mapped subclass of type (" + subclass.getName() + ") must inherit from parent type (" + persistentClass.getName() + ")");
                    }
                    this.processClass(subclass, annotatedClassSet);
                    ++n2;
                }
            }
        }
    }

    private boolean isDaoImplementation(Class beanClass) {
        Class<? extends ManagedDao>[] classArray = this.getDaoImplementations();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends ManagedDao> daoImplementation = classArray[n2];
            if (daoImplementation.isAssignableFrom(beanClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasTargetAnnotation(Class persistentClass) {
        Class<? extends Annotation>[] classArray = this.getTargetAnnotations();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Annotation> targetAnnotation = classArray[n2];
            if (persistentClass.isAnnotationPresent(targetAnnotation)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

