/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.spring.hibernate;

import java.net.URL;
import java.util.HashMap;
import org.smallmind.persistence.orm.SessionSource;
import org.smallmind.persistence.orm.hibernate.HibernateDao;
import org.smallmind.persistence.spring.ManagedDaoSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class FileSeekingBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final UrlResource[] NO_RESOURCES = new UrlResource[0];
    private final HashMap<String, HashMap<Class, UrlResource>> hbmResourceMap = new HashMap();

    public Resource[] getHibernateResources() {
        return this.getResources(null);
    }

    public Resource[] getResources(String sessionSourceKey) {
        HashMap<Class, UrlResource> hbmResourceMap = this.hbmResourceMap.get(sessionSourceKey);
        if (hbmResourceMap == null) {
            return NO_RESOURCES;
        }
        UrlResource[] hbmResources = new UrlResource[hbmResourceMap.size()];
        hbmResourceMap.values().toArray(hbmResources);
        return hbmResources;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        String[] stringArray = configurableListableBeanFactory.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            Class beanClass = configurableListableBeanFactory.getType(beanName);
            if (beanClass != null && HibernateDao.class.isAssignableFrom(beanClass)) {
                HashMap<Class<Object>, Object> hbmResourceMap;
                Class persistentClass = ManagedDaoSupport.findDurableClass(beanClass);
                if (persistentClass == null) {
                    throw new FatalBeanException("No inference of the Durable class for type(" + beanClass.getName() + ") was possible");
                }
                String sessionSourceKey = null;
                SessionSource sessionSource = beanClass.getAnnotation(SessionSource.class);
                if (sessionSource != null) {
                    sessionSourceKey = sessionSource.value();
                }
                if ((hbmResourceMap = this.hbmResourceMap.get(sessionSourceKey)) == null) {
                    hbmResourceMap = new HashMap();
                    this.hbmResourceMap.put(sessionSourceKey, hbmResourceMap);
                }
                while (persistentClass != null && !hbmResourceMap.containsKey(persistentClass)) {
                    int lastSlashIndex;
                    String packageRemnant = persistentClass.getPackage().getName().replace('.', '/');
                    String hbmFileName = String.valueOf(persistentClass.getSimpleName()) + ".hbm.xml";
                    do {
                        URL hbmURL;
                        if ((hbmURL = configurableListableBeanFactory.getBeanClassLoader().getResource(packageRemnant.length() > 0 ? String.valueOf(packageRemnant) + '/' + hbmFileName : hbmFileName)) == null) continue;
                        hbmResourceMap.put(persistentClass, new UrlResource(hbmURL));
                    } while ((packageRemnant = packageRemnant.length() > 0 ? packageRemnant.substring(0, (lastSlashIndex = packageRemnant.lastIndexOf(47)) >= 0 ? lastSlashIndex : 0) : null) != null);
                    persistentClass = persistentClass.getSuperclass();
                }
            }
            ++n2;
        }
    }
}

