/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.spring.jpa;

import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.smallmind.persistence.orm.spring.jpa.AnnotationSeekingBeanFactoryPostProcessor;
import org.springframework.beans.BeanUtils;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.util.ClassUtils;

public class EntitySeekingEntityManagerFactoryBean
extends AbstractEntityManagerFactoryBean {
    private AnnotationSeekingBeanFactoryPostProcessor annotationSeekingBeanFactoryPostProcessor;
    private DataSource dataSource;
    private DataSource jtaDataSource;
    private SharedCacheMode sharedCacheMode;
    private CacheStoreMode cacheStoreMode;
    private CacheRetrieveMode cacheRetrieveMode;
    private ValidationMode validationMode;
    private PersistenceUnitPostProcessor[] persistenceUnitPostProcessors;
    private MutablePersistenceUnitInfo persistenceUnitInfo;
    private String sessionSourceKey;
    private boolean excludeUnlistedClasses = false;

    public void setAnnotationSeekingBeanFactoryPostProcessor(AnnotationSeekingBeanFactoryPostProcessor annotationSeekingBeanFactoryPostProcessor) {
        this.annotationSeekingBeanFactoryPostProcessor = annotationSeekingBeanFactoryPostProcessor;
    }

    public void setSessionSourceKey(String sessionSourceKey) {
        this.sessionSourceKey = sessionSourceKey;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
    }

    public void setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
    }

    public void setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        this.cacheStoreMode = cacheStoreMode;
    }

    public void setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        this.cacheRetrieveMode = cacheRetrieveMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public void setPersistenceUnitInfo(MutablePersistenceUnitInfo persistenceUnitInfo) {
        this.persistenceUnitInfo = persistenceUnitInfo;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public void setPersistenceUnitPostProcessors(PersistenceUnitPostProcessor ... persistenceUnitPostProcessors) {
        this.persistenceUnitPostProcessors = persistenceUnitPostProcessors;
    }

    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        PersistenceProvider provider;
        int n;
        int n2;
        Class[] classArray;
        if (this.persistenceUnitInfo == null) {
            this.persistenceUnitInfo = new MutablePersistenceUnitInfo();
        }
        this.persistenceUnitInfo.setExcludeUnlistedClasses(this.excludeUnlistedClasses);
        if (this.annotationSeekingBeanFactoryPostProcessor != null) {
            classArray = this.annotationSeekingBeanFactoryPostProcessor.getAnnotatedClasses(this.sessionSourceKey);
            n2 = classArray.length;
            n = 0;
            while (n < n2) {
                Class entityClass = classArray[n];
                this.persistenceUnitInfo.addManagedClassName(entityClass.getName());
                ++n;
            }
        }
        if (this.dataSource != null) {
            this.persistenceUnitInfo.setNonJtaDataSource(this.dataSource);
            this.persistenceUnitInfo.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
        }
        if (this.jtaDataSource != null) {
            this.persistenceUnitInfo.setJtaDataSource(this.dataSource);
            this.persistenceUnitInfo.setTransactionType(PersistenceUnitTransactionType.JTA);
        }
        if (this.sharedCacheMode != null) {
            this.persistenceUnitInfo.setSharedCacheMode(this.sharedCacheMode);
        }
        if (this.cacheStoreMode != null) {
            this.persistenceUnitInfo.getProperties().setProperty("javax.persistence.cache.storeMode", this.cacheStoreMode.name());
        }
        if (this.cacheRetrieveMode != null) {
            this.persistenceUnitInfo.getProperties().setProperty("javax.persistence.cache.retrieveMode", this.cacheRetrieveMode.name());
        }
        if (this.validationMode != null) {
            this.persistenceUnitInfo.setValidationMode(this.validationMode);
        }
        if (this.getJpaVendorAdapter() != null) {
            this.persistenceUnitInfo.setPersistenceProviderPackageName(this.getJpaVendorAdapter().getPersistenceProviderRootPackage());
        }
        if (this.persistenceUnitPostProcessors != null) {
            classArray = this.persistenceUnitPostProcessors;
            n2 = this.persistenceUnitPostProcessors.length;
            n = 0;
            while (n < n2) {
                Class persistenceUnitPostProcessor = classArray[n];
                persistenceUnitPostProcessor.postProcessPersistenceUnitInfo(this.persistenceUnitInfo);
                ++n;
            }
        }
        if ((provider = this.getPersistenceProvider()) == null) {
            String providerClassName = this.persistenceUnitInfo.getPersistenceProviderClassName();
            if (providerClassName == null) {
                throw new IllegalArgumentException("No PersistenceProvider specified in EntityManagerFactory configuration, and chosen PersistenceUnitInfo does not specify a provider class name either");
            }
            provider = (PersistenceProvider)BeanUtils.instantiateClass((Class)ClassUtils.resolveClassName((String)providerClassName, (ClassLoader)this.getBeanClassLoader()));
        }
        if (this.persistenceUnitInfo.getPersistenceUnitName() != null) {
            this.setPersistenceUnitName(this.persistenceUnitInfo.getPersistenceUnitName());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Building JPA container EntityManagerFactory for persistence unit '" + this.persistenceUnitInfo.getPersistenceUnitName() + "'"));
        }
        return provider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.persistenceUnitInfo, this.getJpaPropertyMap());
    }
}

