/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.orm.spring.morphia;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import java.util.Arrays;
import java.util.HashSet;
import org.bson.conversions.Bson;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.annotations.Entity;
import org.smallmind.persistence.orm.ORMInitializationException;
import org.smallmind.persistence.orm.morphia.DataStoreFactory;
import org.smallmind.persistence.orm.spring.morphia.AnnotationSeekingBeanFactoryPostProcessor;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class EntitySeekingDataStoreFactoryBean
implements FactoryBean<DataStoreFactory>,
InitializingBean {
    private DataStoreFactory dataStoreFactory;
    private AnnotationSeekingBeanFactoryPostProcessor annotationSeekingBeanFactoryPostProcessor;
    private MongoClient mongoClient;
    private String sessionSourceKey;
    private String databaseName;
    private boolean enableShards = false;

    public void setAnnotationSeekingBeanFactoryPostProcessor(AnnotationSeekingBeanFactoryPostProcessor annotationSeekingBeanFactoryPostProcessor) {
        this.annotationSeekingBeanFactoryPostProcessor = annotationSeekingBeanFactoryPostProcessor;
    }

    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setSessionSourceKey(String sessionSourceKey) {
        this.sessionSourceKey = sessionSourceKey;
    }

    public void setEnableShards(boolean enableShards) {
        this.enableShards = enableShards;
    }

    public Class getObjectType() {
        return DataStoreFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public DataStoreFactory getObject() {
        return this.dataStoreFactory;
    }

    public void afterPropertiesSet() {
        HashSet<Class> entitySet = new HashSet<Class>(Arrays.asList(this.annotationSeekingBeanFactoryPostProcessor.getAnnotatedClasses(this.sessionSourceKey)));
        Morphia morphia = new Morphia(entitySet);
        Datastore datastore = morphia.createDatastore(this.mongoClient, this.databaseName);
        if (this.enableShards) {
            this.mongoClient.getDatabase("admin").runCommand((Bson)new BasicDBObject("enableSharding", (Object)this.databaseName));
            for (Class entityClass : entitySet) {
                Entity entityAnnotation = entityClass.getAnnotation(Entity.class);
                if (entityAnnotation == null) {
                    throw new ORMInitializationException("The morphia entity(%s) is missing an @%s annotation", entityClass.getName(), Entity.class.getSimpleName());
                }
                this.mongoClient.getDatabase("admin").runCommand((Bson)new BasicDBObject("shardCollection", (Object)(String.valueOf(this.databaseName) + '.' + entityAnnotation.value())).append("key", (Object)new BasicDBObject("_id", (Object)"hashed")));
            }
        }
        datastore.ensureIndexes();
        this.dataStoreFactory = new DataStoreFactory(datastore);
    }
}

