/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.query;

import java.time.ZonedDateTime;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.smallmind.nutsnbolts.json.ZonedDateTimeXmlAdapter;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.persistence.query.ArrayValueXmlAdapter;
import org.smallmind.persistence.query.WhereOperand;

@XmlRootElement(name="array")
public class ArrayWhereOperand
implements WhereOperand<Object[], Object[]> {
    private static final ZonedDateTimeXmlAdapter ZONED_DATE_TIME_XML_ADAPTER = new ZonedDateTimeXmlAdapter();
    private Object[] value;
    private String typeHint;

    public ArrayWhereOperand() {
    }

    public ArrayWhereOperand(String typeHint, Object[] value) {
        this.typeHint = typeHint;
        this.value = value;
    }

    public static ArrayWhereOperand instance(String typeHint, Object[] value) {
        return new ArrayWhereOperand(typeHint, value);
    }

    @Override
    @XmlTransient
    public Class<? extends Object[]> getTargetClass() {
        switch (this.typeHint) {
            case "boolean": {
                return Boolean[].class;
            }
            case "byte": {
                return Byte[].class;
            }
            case "character": {
                return Character[].class;
            }
            case "date": {
                return Date[].class;
            }
            case "double": {
                return Double[].class;
            }
            case "float": {
                return Float[].class;
            }
            case "integer": {
                return Integer[].class;
            }
            case "long": {
                return Long[].class;
            }
            case "short": {
                return Short[].class;
            }
            case "string": {
                return String[].class;
            }
            case "enum": {
                return Enum[].class;
            }
        }
        throw new UnknownSwitchCaseException(this.typeHint, new Object[0]);
    }

    @Override
    @XmlElement(name="type", required=true)
    public String getTypeHint() {
        return this.typeHint;
    }

    public void setTypeHint(String typeHint) {
        this.typeHint = typeHint;
    }

    @Override
    @XmlElement(name="value", required=true)
    @XmlJavaTypeAdapter(value=ArrayValueXmlAdapter.class)
    public Object[] getValue() {
        if (this.value == null) {
            return null;
        }
        switch (this.typeHint) {
            case "boolean": {
                Object[] booleanArray = new Boolean[this.value.length];
                int index = 0;
                while (index < this.value.length) {
                    booleanArray[index] = (Boolean)this.value[index];
                    ++index;
                }
                return booleanArray;
            }
            case "byte": {
                Object[] byteArray = new Byte[this.value.length];
                int index = 0;
                while (index < this.value.length) {
                    byteArray[index] = this.value[index] == null ? null : Byte.valueOf(((Integer)this.value[index]).byteValue());
                    ++index;
                }
                return byteArray;
            }
            case "character": {
                Object[] characterArray = new Character[this.value.length];
                int index = 0;
                while (index < this.value.length) {
                    String string;
                    characterArray[index] = this.value[index] == null ? null : ((string = this.value[index].toString()).length() == 0 ? null : Character.valueOf(string.charAt(0)));
                    ++index;
                }
                return characterArray;
            }
            case "date": {
                Object[] dateTimes = new ZonedDateTime[this.value.length];
                int index = 0;
                while (index < this.value.length) {
                    dateTimes[index] = this.value[index] == null ? null : ZONED_DATE_TIME_XML_ADAPTER.unmarshal(this.value[index].toString());
                    ++index;
                }
                return dateTimes;
            }
            case "double": {
                Object[] doubleArray = new Double[this.value.length];
                int index = 0;
                while (index < this.value.length) {
                    doubleArray[index] = (Double)this.value[index];
                    ++index;
                }
                return doubleArray;
            }
            case "float": {
                Object[] floatArray = new Float[this.value.length];
                int index = 0;
                while (index < this.value.length) {
                    floatArray[index] = this.value[index] == null ? null : Float.valueOf(((Double)this.value[index]).floatValue());
                    ++index;
                }
                return floatArray;
            }
            case "integer": {
                Object[] integerArray = new Integer[this.value.length];
                int index = 0;
                while (index < this.value.length) {
                    integerArray[index] = (Integer)this.value[index];
                    ++index;
                }
                return integerArray;
            }
            case "long": {
                Object[] longArray = new Long[this.value.length];
                int index = 0;
                while (index < this.value.length) {
                    longArray[index] = this.value[index] == null ? null : Long.valueOf(this.value[index] instanceof Integer ? ((Integer)this.value[index]).longValue() : ((Long)this.value[index]).longValue());
                    ++index;
                }
                return longArray;
            }
            case "short": {
                Object[] shortArray = new Short[this.value.length];
                int index = 0;
                while (index < this.value.length) {
                    shortArray[index] = this.value[index] == null ? null : Short.valueOf(((Integer)this.value[index]).shortValue());
                    ++index;
                }
                return shortArray;
            }
            case "string": {
                Object[] stringArray = new String[this.value.length];
                int index = 0;
                while (index < this.value.length) {
                    stringArray[index] = this.value[index] == null ? null : this.value[index].toString();
                    ++index;
                }
                return stringArray;
            }
            case "enum": {
                return this.value;
            }
        }
        throw new UnknownSwitchCaseException(this.typeHint, new Object[0]);
    }

    public void setValue(Object[] value) {
        this.value = value;
    }
}

