/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.query;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlTransient;
import org.smallmind.persistence.query.AndWhereConjunction;
import org.smallmind.persistence.query.ConjunctionType;
import org.smallmind.persistence.query.CriterionType;
import org.smallmind.persistence.query.OrWhereConjunction;
import org.smallmind.persistence.query.WhereCriterion;
import org.smallmind.persistence.query.WhereField;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
public abstract class WhereConjunction
implements WhereCriterion {
    private List<WhereCriterion> criterionList;

    public WhereConjunction() {
    }

    public WhereConjunction(WhereCriterion ... criteria) {
        this.criterionList = new LinkedList<WhereCriterion>();
        WhereCriterion[] whereCriterionArray = criteria;
        int n = criteria.length;
        int n2 = 0;
        while (n2 < n) {
            WhereCriterion criterion = whereCriterionArray[n2];
            if (criterion != null) {
                this.criterionList.add(criterion);
            }
            ++n2;
        }
    }

    public abstract ConjunctionType getConjunctionType();

    @Override
    @XmlTransient
    public CriterionType getCriterionType() {
        return CriterionType.CONJUNCTION;
    }

    @XmlTransient
    public synchronized boolean isEmpty() {
        return this.criterionList == null || this.criterionList.isEmpty();
    }

    @XmlElement(name="criteria")
    @XmlElementRefs(value={@XmlElementRef(type=WhereField.class), @XmlElementRef(type=AndWhereConjunction.class), @XmlElementRef(type=OrWhereConjunction.class)})
    public synchronized WhereCriterion[] getCriteria() {
        WhereCriterion[] criteria = new WhereCriterion[this.criterionList == null ? 0 : this.criterionList.size()];
        if (this.criterionList != null) {
            this.criterionList.toArray(criteria);
        }
        return criteria;
    }

    public synchronized void setCriteria(WhereCriterion ... criteria) {
        this.criterionList = Arrays.asList(criteria);
    }

    public synchronized void addCriterion(WhereCriterion criterion) {
        if (this.criterionList == null) {
            this.criterionList = new LinkedList<WhereCriterion>();
        }
        this.criterionList.add(criterion);
    }
}

