/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.query;

import java.lang.reflect.Array;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import org.smallmind.persistence.orm.ORMOperationException;
import org.smallmind.persistence.query.WhereOperand;
import org.smallmind.persistence.query.WhereOperandTransform;

public class WhereOperandTransformer {
    private static final WhereOperandTransformer DEFAULT_TRANSFORMER = new WhereOperandTransformer();
    private HashMap<TransformKey<?, ?>, WhereOperandTransform<?, ?>> transformMap = new HashMap();

    public WhereOperandTransformer() {
        this.transformMap.put(new TransformKey(ZonedDateTime.class, Date.class), (typeHint, zonedDateTime) -> Date.from(zonedDateTime.toInstant()));
        this.transformMap.put(new TransformKey(String.class, Enum.class), (typeHint, name) -> {
            throw new ORMOperationException("Missing transform for enum(%s)", typeHint);
        });
    }

    public static WhereOperandTransformer instance() {
        return DEFAULT_TRANSFORMER;
    }

    public synchronized <I, O> WhereOperandTransformer add(Class<I> inputClass, Class<O> outputClass, WhereOperandTransform<I, O> transform) {
        this.transformMap.put(new TransformKey(inputClass, outputClass), transform);
        return this;
    }

    public synchronized <I, O> O transform(WhereOperand<I, O> whereOperand) {
        I input = whereOperand.getValue();
        if (input == null) {
            return null;
        }
        Class<O> clazz = whereOperand.getTargetClass();
        if (clazz.isAssignableFrom(input.getClass())) {
            return clazz.cast(input);
        }
        if (clazz.isArray()) {
            if (!input.getClass().isArray()) {
                throw new ORMOperationException("Attempt to apply non-array type(%s) into array type(%s)", input.getClass().getName(), clazz.getName());
            }
            WhereOperandTransform<?, ?> transform = this.transformMap.get(new TransformKey(input.getClass().getComponentType(), clazz.getComponentType()));
            if (transform == null) {
                throw new ORMOperationException("Missing transform from input type(%s) to output(%s)", input.getClass().getComponentType(), clazz.getComponentType());
            }
            int arrayLength = Array.getLength(input);
            Object[] output = (Object[])Array.newInstance(clazz.getComponentType(), arrayLength);
            int index = 0;
            while (index < arrayLength) {
                output[index] = transform.apply(whereOperand.getTypeHint(), Array.get(input, index));
                ++index;
            }
            return clazz.cast(output);
        }
        WhereOperandTransform<?, ?> transform = this.transformMap.get(new TransformKey(input.getClass(), clazz));
        if (transform == null) {
            throw new ORMOperationException("Missing transform from input type(%s) to output(%s)", input.getClass(), clazz);
        }
        return (O)transform.apply(whereOperand.getTypeHint(), input);
    }

    private class TransformKey<T, U> {
        private Class<T> inputClass;
        private Class<U> outputClass;

        private TransformKey(Class<T> inputClass, Class<U> outputClass) {
            this.inputClass = inputClass;
            this.outputClass = outputClass;
        }

        private Class<T> getInputClass() {
            return this.inputClass;
        }

        private Class<U> getOutputClass() {
            return this.outputClass;
        }

        public int hashCode() {
            return this.inputClass.hashCode() ^ this.outputClass.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TransformKey && this.inputClass.equals(((TransformKey)obj).getInputClass()) && this.outputClass.equals(((TransformKey)obj).getOutputClass());
        }
    }
}

