/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.persistence.query.DependentWherePermit;
import org.smallmind.persistence.query.WherePermit;
import org.smallmind.persistence.query.WhereValidationException;

public interface WherePermissible<W extends WherePermissible<W>> {
    public static final /* synthetic */ int[] $SWITCH_TABLE$org$smallmind$persistence$query$PermitType;

    public Set<WherePermit> getTargetSet();

    default public W validate(WherePermit ... permits) {
        if (permits != null && permits.length > 0) {
            Set<WherePermit> requestedSet = this.getTargetSet();
            HashSet<WherePermit> allowedSet = new HashSet<WherePermit>();
            HashSet<WherePermit> requiredSet = new HashSet<WherePermit>();
            HashSet<WherePermit> excludedSet = new HashSet<WherePermit>();
            HashSet<WherePermit> failedDependencySet = new HashSet<WherePermit>();
            WherePermit[] wherePermitArray = permits;
            int n = permits.length;
            int n2 = 0;
            while (n2 < n) {
                WherePermit permit = wherePermitArray[n2];
                switch (permit.getType()) {
                    case ALLOWED: {
                        allowedSet.add(permit);
                        break;
                    }
                    case REQUIRED: {
                        allowedSet.add(permit);
                        requiredSet.add(permit);
                        break;
                    }
                    case EXCLUDED: {
                        excludedSet.add(permit);
                        break;
                    }
                    case DEPENDENT: {
                        if (requestedSet.contains(permit) && !requestedSet.contains(((DependentWherePermit)permit).getRequirement())) {
                            failedDependencySet.add(permit);
                        }
                    }
                    default: {
                        throw new UnknownSwitchCaseException(permit.getType().name(), new Object[0]);
                    }
                }
                ++n2;
            }
            for (WherePermit target : requestedSet) {
                if (excludedSet.contains(target)) {
                    throw new WhereValidationException("The element(%s) is not permitted in %s clauses for this query", target, this.getClass().getSimpleName());
                }
                if (allowedSet.isEmpty() || allowedSet.contains(target)) continue;
                throw new WhereValidationException("The element(%s) is not permitted in %s clauses for this query", target, this.getClass().getSimpleName());
            }
            if (!requestedSet.containsAll(requiredSet)) {
                throw new WhereValidationException("The elements(%s) are required in %s clauses for this query", Arrays.toString(requiredSet.toArray()), this.getClass().getSimpleName());
            }
            if (!failedDependencySet.isEmpty()) {
                throw new WhereValidationException("The elements(%s) have failed dependencies for this query", Arrays.toString(failedDependencySet.toArray()), this.getClass().getSimpleName());
            }
        }
        return (W)this;
    }
}

