/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.query;

import java.util.Objects;
import org.smallmind.persistence.query.AllowedWherePermit;
import org.smallmind.persistence.query.DependentWherePermit;
import org.smallmind.persistence.query.ExcludedWherePermit;
import org.smallmind.persistence.query.PermitType;
import org.smallmind.persistence.query.RequiredWherePermit;
import org.smallmind.persistence.query.TargetWherePermit;

public abstract class WherePermit {
    private String entity;
    private String name;

    public WherePermit(String entity, String name) {
        this(name);
        this.entity = entity;
    }

    public WherePermit(String name) {
        this.name = name;
    }

    public static AllowedWherePermit allowed(String entity, String name) {
        return new AllowedWherePermit(entity, name);
    }

    public static RequiredWherePermit required(String entity, String name) {
        return new RequiredWherePermit(entity, name);
    }

    public static ExcludedWherePermit excluded(String entity, String name) {
        return new ExcludedWherePermit(entity, name);
    }

    public static DependentWherePermit dependent(String entity, String name, TargetWherePermit requirement) {
        return new DependentWherePermit(entity, name, requirement);
    }

    public abstract PermitType getType();

    public String getEntity() {
        return this.entity;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.entity == null ? this.name : String.valueOf(this.entity) + '.' + this.name;
    }

    public int hashCode() {
        return this.entity == null ? this.name.hashCode() : 31 * this.entity.hashCode() + this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof WherePermit && this.name.equals(((WherePermit)obj).getName()) && Objects.equals(this.entity, ((WherePermit)obj).getEntity());
    }
}

