/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.query;

import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.persistence.query.Where;
import org.smallmind.persistence.query.WhereConjunction;
import org.smallmind.persistence.query.WhereCriterion;
import org.smallmind.persistence.query.WhereField;
import org.smallmind.persistence.query.WhereVisitor;

public class WhereUtility {
    public static void walk(Where where, WhereVisitor visitor) {
        WhereUtility.walkConjunction(where.getRootConjunction(), visitor);
    }

    private static void walkConjunction(WhereConjunction whereConjunction, WhereVisitor visitor) {
        visitor.visitConjunction(whereConjunction);
        WhereCriterion[] whereCriterionArray = whereConjunction.getCriteria();
        int n = whereCriterionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WhereCriterion criterion = whereCriterionArray[n2];
            switch (criterion.getCriterionType()) {
                case CONJUNCTION: {
                    WhereUtility.walkConjunction((WhereConjunction)criterion, visitor);
                    break;
                }
                case FIELD: {
                    visitor.visitField((WhereField)criterion);
                    break;
                }
                default: {
                    throw new UnknownSwitchCaseException(criterion.getCriterionType().name(), new Object[0]);
                }
            }
            ++n2;
        }
    }
}

