/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.query;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.smallmind.persistence.query.Allowed;
import org.smallmind.persistence.query.AllowedWherePermit;
import org.smallmind.persistence.query.DependentWherePermit;
import org.smallmind.persistence.query.RequiredWherePermit;
import org.smallmind.persistence.query.TargetWherePermit;
import org.smallmind.persistence.query.WhereConstraint;
import org.smallmind.persistence.query.WherePermissible;
import org.smallmind.persistence.query.WherePermit;
import org.smallmind.persistence.query.WhereValidationException;

public class WhereValidator
implements ConstraintValidator<WhereConstraint, WherePermissible> {
    private WhereConstraint constraintAnnotation;

    public void initialize(WhereConstraint constraintAnnotation) {
        this.constraintAnnotation = constraintAnnotation;
    }

    public boolean isValid(WherePermissible permissible, ConstraintValidatorContext context) {
        LinkedList<WherePermit> permitList = new LinkedList<WherePermit>();
        Annotation[] annotationArray = this.constraintAnnotation.allow();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Allowed allowed = annotationArray[n2];
            permitList.add(new AllowedWherePermit(allowed.entity(), allowed.field()));
            ++n2;
        }
        annotationArray = this.constraintAnnotation.require();
        n = annotationArray.length;
        n2 = 0;
        while (n2 < n) {
            Annotation required = annotationArray[n2];
            permitList.add(new RequiredWherePermit(required.entity(), required.field()));
            ++n2;
        }
        annotationArray = this.constraintAnnotation.exclude();
        n = annotationArray.length;
        n2 = 0;
        while (n2 < n) {
            Annotation excluded = annotationArray[n2];
            permitList.add(new AllowedWherePermit(excluded.entity(), excluded.field()));
            ++n2;
        }
        annotationArray = this.constraintAnnotation.dependencies();
        n = annotationArray.length;
        n2 = 0;
        while (n2 < n) {
            Annotation dependent = annotationArray[n2];
            permitList.add(new DependentWherePermit(dependent.entity(), dependent.field(), new TargetWherePermit(dependent.requirement().entity(), dependent.requirement().field())));
            ++n2;
        }
        WherePermit[] wherePermits = new WherePermit[permitList.size()];
        permitList.toArray(wherePermits);
        try {
            permissible.validate(wherePermits);
            return true;
        }
        catch (WhereValidationException whereValidationException) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(whereValidationException.getMessage()).addConstraintViolation();
            return false;
        }
    }
}

