/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.spring;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.smallmind.persistence.Durable;
import org.springframework.beans.FatalBeanException;

public class ManagedDaoSupport {
    public static Class findDurableClass(Class beanClass) {
        Class currentClass = beanClass;
        try {
            Type returnType = ((ParameterizedType)beanClass.getMethod("getManagedClass", new Class[0]).getGenericReturnType()).getActualTypeArguments()[0];
            if (returnType instanceof Class) {
                return (Class)returnType;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new FatalBeanException("HibernateDao classes are expected to contain the method getManagedClass()", (Throwable)noSuchMethodException);
        }
        do {
            Type superType;
            if ((superType = currentClass.getGenericSuperclass()) == null || !(superType instanceof ParameterizedType)) continue;
            Type[] typeArray = ((ParameterizedType)superType).getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type genericType = typeArray[n2];
                if (genericType instanceof Class && Durable.class.isAssignableFrom((Class)genericType)) {
                    return (Class)genericType;
                }
                ++n2;
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return null;
    }
}

