/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import org.smallmind.nutsnbolts.lang.Existential;
import org.smallmind.nutsnbolts.lang.StaticInitializationError;
import org.smallmind.persistence.sql.PooledConnectionException;
import org.smallmind.persistence.sql.PooledPreparedStatement;
import org.smallmind.persistence.sql.PooledPreparedStatementCache;

public abstract class AbstractPooledConnection<D extends CommonDataSource>
implements PooledConnection,
InvocationHandler {
    private static final Method CLOSE_METHOD;
    private final PooledPreparedStatementCache statementCache;
    private D dataSource;
    private Connection actualConnection;
    private Connection proxyConnection;
    private ConcurrentLinkedQueue<ConnectionEventListener> connectionEventListenerQueue;
    private ConcurrentLinkedQueue<StatementEventListener> statementEventListenerQueue;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private long creationMilliseconds;

    static {
        try {
            CLOSE_METHOD = Connection.class.getMethod("close", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new StaticInitializationError((Throwable)noSuchMethodException);
        }
    }

    public AbstractPooledConnection(D dataSource, Connection actualConnection, int maxStatements) throws SQLException {
        this.dataSource = dataSource;
        this.actualConnection = actualConnection;
        if (maxStatements < 0) {
            throw new SQLException("The maximum number of cached statements for this connection must be >= 0");
        }
        this.creationMilliseconds = System.currentTimeMillis();
        this.proxyConnection = (Connection)Proxy.newProxyInstance(dataSource.getClass().getClassLoader(), new Class[]{Connection.class, Existential.class}, (InvocationHandler)this);
        this.connectionEventListenerQueue = new ConcurrentLinkedQueue();
        this.statementEventListenerQueue = new ConcurrentLinkedQueue();
        if (maxStatements == 0) {
            this.statementCache = null;
        } else {
            this.statementCache = new PooledPreparedStatementCache(maxStatements);
            this.addStatementEventListener(this.statementCache);
        }
    }

    public abstract ConnectionEvent getConnectionEvent(SQLException var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        block10: {
            if (AbstractPooledConnection.CLOSE_METHOD.equals(method)) {
                event = this.getConnectionEvent(null);
                for (ConnectionEventListener listener : this.connectionEventListenerQueue) {
                    listener.connectionClosed(event);
                }
                return null;
            }
            try {
                if (this.statementCache != null && PreparedStatement.class.isAssignableFrom(method.getReturnType())) {
                    listener = this.statementCache;
                    synchronized (listener) {
                        preparedStatement = this.statementCache.getPreparedStatement(args);
                        if (preparedStatement == null) {
                            preparedStatement = this.statementCache.cachePreparedStatement(args, new PooledPreparedStatement(this, (PreparedStatement)method.invoke((Object)this.actualConnection, args)));
                        }
                    }
                    return preparedStatement;
                }
                return method.invoke((Object)this.actualConnection, args);
            }
            catch (Throwable throwable) {
                v1 = closestCause = throwable instanceof InvocationTargetException != false && throwable.getCause() != null ? throwable.getCause() : throwable;
                if (!(closestCause instanceof SQLException)) break block10;
                event = this.getConnectionEvent((SQLException)closestCause);
                ** for (listener : this.connectionEventListenerQueue)
            }
lbl-1000:
            // 1 sources

            {
                listener.connectionErrorOccurred(event);
                continue;
            }
        }
        throw new PooledConnectionException(closestCause, "Connection encountered an exception after operation for %d milliseconds", new Object[]{System.currentTimeMillis() - this.creationMilliseconds});
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public Connection getConnection() {
        return this.proxyConnection;
    }

    @Override
    public void close() throws SQLException {
        block7: {
            if (this.closed.compareAndSet(false, true)) {
                try {
                    if (this.statementCache == null) break block7;
                    try {
                        this.statementCache.close();
                    }
                    finally {
                        this.removeStatementEventListener(this.statementCache);
                    }
                }
                finally {
                    this.actualConnection.close();
                }
            }
        }
    }

    public void finalize() throws SQLException {
        block2: {
            try {
                this.close();
            }
            catch (SQLException sqlException) {
                PrintWriter logWriter = this.getLogWriter();
                if (logWriter == null) break block2;
                sqlException.printStackTrace(logWriter);
            }
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListenerQueue.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListenerQueue.remove(listener);
    }

    protected Iterable<StatementEventListener> getStatementEventListeners() {
        return this.statementEventListenerQueue;
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.statementEventListenerQueue.add(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListenerQueue.remove(listener);
    }
}

