/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DriverManagerDataSource
implements DataSource {
    private PrintWriter logWriter;
    private String jdbcUrl;
    private String user;
    private String password;

    public DriverManagerDataSource(String driverClassName, String jdbcUrl, String user, String password) throws SQLException {
        this.jdbcUrl = jdbcUrl;
        this.user = user;
        this.password = password;
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(classNotFoundException);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, this.user, this.password);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, user, password);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public void setLoginTimeout(int timeoutSeconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }
}

