/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.smallmind.persistence.sql.PooledConnectionFactory;

public class OmnivorousConnectionPoolDataSource<D extends CommonDataSource, P extends PooledConnection>
implements ConnectionPoolDataSource {
    private D dataSource;
    private Class<P> pooledConnectionClass;
    private int maxStatements = 0;

    public OmnivorousConnectionPoolDataSource(D dataSource, Class<P> pooledConnectionClass) {
        this.dataSource = dataSource;
        this.pooledConnectionClass = pooledConnectionClass;
    }

    public OmnivorousConnectionPoolDataSource(D dataSource, Class<P> pooledConnectionClass, int maxStatements) {
        this(dataSource, pooledConnectionClass);
        this.maxStatements = maxStatements;
    }

    public P getPooledConnection() throws SQLException {
        return (P)((PooledConnection)this.pooledConnectionClass.cast(PooledConnectionFactory.createPooledConnection(this.dataSource, this.maxStatements)));
    }

    public P getPooledConnection(String user, String password) throws SQLException {
        return (P)((PooledConnection)this.pooledConnectionClass.cast(PooledConnectionFactory.createPooledConnection(this.dataSource, user, password, this.maxStatements)));
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }
}

