/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql;

import java.sql.SQLException;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;
import org.smallmind.persistence.sql.DataSourcePooledConnection;
import org.smallmind.persistence.sql.XADataSourcePooledConnection;

public class PooledConnectionFactory {
    public static <D extends CommonDataSource> PooledConnection createPooledConnection(D dataSource, int maxStatements) throws SQLException {
        if (XADataSource.class.isAssignableFrom(dataSource.getClass())) {
            return new XADataSourcePooledConnection((XADataSource)dataSource, maxStatements);
        }
        return new DataSourcePooledConnection((DataSource)dataSource, maxStatements);
    }

    public static <D extends CommonDataSource> PooledConnection createPooledConnection(D dataSource, String user, String password, int maxStatements) throws SQLException {
        if (XADataSource.class.isAssignableFrom(dataSource.getClass())) {
            return new XADataSourcePooledConnection((XADataSource)dataSource, user, password, maxStatements);
        }
        return new DataSourcePooledConnection((DataSource)dataSource, user, password, maxStatements);
    }
}

