/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.StatementEventListener;
import org.smallmind.persistence.sql.AbstractPooledConnection;
import org.smallmind.persistence.sql.PooledPreparedStatementEvent;

public class PooledPreparedStatement
implements InvocationHandler {
    private AbstractPooledConnection<?> pooledConnection;
    private PreparedStatement actualStatement;
    private PreparedStatement proxyStatement;
    private String statementId;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public PooledPreparedStatement(AbstractPooledConnection<?> pooledConnection, PreparedStatement actualStatement) {
        this.pooledConnection = pooledConnection;
        this.actualStatement = actualStatement;
        this.statementId = UUID.randomUUID().toString();
        this.proxyStatement = (PreparedStatement)Proxy.newProxyInstance(PooledPreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)this);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        block5: {
            if (method.getName().equals("close")) {
                event = new PooledPreparedStatementEvent(this.pooledConnection, this.actualStatement, this.statementId);
                for (StatementEventListener listener : this.pooledConnection.getStatementEventListeners()) {
                    listener.statementClosed(event);
                }
                return null;
            }
            try {
                return method.invoke((Object)this.actualStatement, args);
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof SQLException)) break block5;
                event = new PooledPreparedStatementEvent(this.pooledConnection, this.actualStatement, (SQLException)throwable, this.statementId);
                ** for (listener : this.pooledConnection.getStatementEventListeners())
            }
lbl-1000:
            // 1 sources

            {
                listener.statementErrorOccurred(event);
                continue;
            }
        }
        throw throwable;
    }

    public String getStatementId() {
        return this.statementId;
    }

    public PreparedStatement getPreparedStatement() {
        return this.proxyStatement;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.pooledConnection.getLogWriter();
    }

    public void close() throws SQLException {
        if (this.closed.compareAndSet(false, true)) {
            this.actualStatement.close();
        }
    }

    public void finalize() throws SQLException {
        block2: {
            try {
                this.close();
            }
            catch (SQLException sqlExecption) {
                PrintWriter logWriter = this.getLogWriter();
                if (logWriter == null) break block2;
                sqlExecption.printStackTrace(logWriter);
            }
        }
    }
}

