/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql;

import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.smallmind.persistence.sql.PooledPreparedStatement;
import org.smallmind.persistence.sql.PooledPreparedStatementEvent;

public class PooledPreparedStatementCache
implements StatementEventListener {
    private TreeMap<TimeKey, String> timeMap;
    private HashMap<ArgumentKey, LinkedList<String>> argumentMap;
    private HashMap<String, StatementWrapper> statementMap;
    private int maxStatements;

    public PooledPreparedStatementCache(int maxStatements) {
        this.maxStatements = maxStatements;
        this.timeMap = new TreeMap();
        this.argumentMap = new HashMap();
        this.statementMap = new HashMap();
    }

    public synchronized PreparedStatement cachePreparedStatement(Object[] args, PooledPreparedStatement pooledStatement) {
        ArgumentKey argumentKey;
        StatementWrapper statementWrapper;
        LinkedList<String> statementIdList;
        if (this.statementMap.size() == this.maxStatements && (statementIdList = this.argumentMap.get((statementWrapper = this.statementMap.remove(this.timeMap.remove(this.timeMap.firstKey()))).getArgumentKey())) != null) {
            statementIdList.remove(statementWrapper.getPooledStatement().getStatementId());
            if (statementIdList.isEmpty() && !Arrays.equals(statementWrapper.getArgumentKey().getArgs(), args)) {
                this.argumentMap.remove(statementWrapper.getArgumentKey());
            }
        }
        if ((statementIdList = this.argumentMap.get(argumentKey = new ArgumentKey(args))) == null) {
            statementIdList = new LinkedList();
            this.argumentMap.put(argumentKey, statementIdList);
        }
        statementIdList.add(pooledStatement.getStatementId());
        TimeKey timeKey = new TimeKey();
        this.statementMap.put(pooledStatement.getStatementId(), new StatementWrapper(timeKey, argumentKey, pooledStatement));
        this.timeMap.put(timeKey, pooledStatement.getStatementId());
        return pooledStatement.getPreparedStatement();
    }

    public synchronized PreparedStatement getPreparedStatement(Object[] args) {
        ArgumentKey argumentKey = new ArgumentKey(args);
        LinkedList<String> statementIdList = this.argumentMap.get(argumentKey);
        if (statementIdList != null) {
            for (String statementId : statementIdList) {
                StatementWrapper statementWrapper = this.statementMap.get(statementId);
                if (statementWrapper.isInUse()) continue;
                return statementWrapper.acquire();
            }
        }
        return null;
    }

    @Override
    public synchronized void statementClosed(StatementEvent event) {
        StatementWrapper statementWrapper = this.statementMap.get(((PooledPreparedStatementEvent)event).getStatementId());
        if (statementWrapper != null) {
            statementWrapper.free();
        }
    }

    @Override
    public synchronized void statementErrorOccurred(StatementEvent event) {
        StatementWrapper statementWrapper = this.statementMap.remove(((PooledPreparedStatementEvent)event).getStatementId());
        if (statementWrapper != null) {
            this.timeMap.remove(statementWrapper.getTimeKey());
            LinkedList<String> statementIdList = this.argumentMap.get(statementWrapper.getArgumentKey());
            statementIdList.remove(statementWrapper.getPooledStatement().getStatementId());
            if (statementIdList.isEmpty()) {
                this.argumentMap.remove(statementWrapper.getArgumentKey());
            }
            try {
                statementWrapper.getPooledStatement().close();
            }
            catch (SQLException sqlException) {
                this.logException(statementWrapper, sqlException);
            }
        }
    }

    public synchronized void close() {
        for (StatementWrapper statementWrapper : this.statementMap.values()) {
            try {
                statementWrapper.getPooledStatement().close();
            }
            catch (SQLException sqlException) {
                this.logException(statementWrapper, sqlException);
            }
        }
    }

    private void logException(StatementWrapper statementWrapper, SQLException sqlException) {
        try {
            PrintWriter logWriter = statementWrapper.getPooledStatement().getLogWriter();
            if (logWriter != null) {
                sqlException.printStackTrace(logWriter);
            }
        }
        catch (SQLException sQLException) {}
    }

    private class ArgumentKey {
        private Object[] args;

        public ArgumentKey(Object[] args) {
            this.args = args;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.args);
        }

        public boolean equals(Object obj) {
            return obj instanceof ArgumentKey && Arrays.equals(this.args, ((ArgumentKey)obj).getArgs());
        }
    }

    private class StatementWrapper {
        private TimeKey timeKey;
        private ArgumentKey argumentKey;
        private PooledPreparedStatement pooledStatement;
        private boolean inUse;

        public StatementWrapper(TimeKey timeKey, ArgumentKey argumentKey, PooledPreparedStatement pooledStatement) {
            this.timeKey = timeKey;
            this.argumentKey = argumentKey;
            this.pooledStatement = pooledStatement;
            this.inUse = true;
        }

        public TimeKey getTimeKey() {
            return this.timeKey;
        }

        public ArgumentKey getArgumentKey() {
            return this.argumentKey;
        }

        public PooledPreparedStatement getPooledStatement() {
            return this.pooledStatement;
        }

        public boolean isInUse() {
            return this.inUse;
        }

        public void free() {
            this.inUse = false;
        }

        public PreparedStatement acquire() {
            this.inUse = true;
            PooledPreparedStatementCache.this.timeMap.remove(this.timeKey);
            PooledPreparedStatementCache.this.timeMap.put(this.timeKey.update(), this.pooledStatement.getStatementId());
            return this.pooledStatement.getPreparedStatement();
        }
    }

    private class TimeKey
    implements Comparable<TimeKey> {
        private long lastAccesssTime = System.currentTimeMillis();

        public long getLastAccessTime() {
            return this.lastAccesssTime;
        }

        public TimeKey update() {
            this.lastAccesssTime = System.currentTimeMillis();
            return this;
        }

        @Override
        public int compareTo(TimeKey timeKey) {
            return Long.compare(this.lastAccesssTime, timeKey.getLastAccessTime());
        }
    }
}

