/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql;

import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.smallmind.persistence.sql.AbstractPooledConnection;

public class XADataSourcePooledConnection
extends AbstractPooledConnection<XADataSource>
implements XAConnection {
    private XAConnection xaConnection;

    public XADataSourcePooledConnection(XADataSource dataSource, int maxStatements) throws SQLException {
        this(dataSource, dataSource.getXAConnection(), maxStatements);
    }

    public XADataSourcePooledConnection(XADataSource dataSource, String user, String password, int maxStatements) throws SQLException {
        this(dataSource, dataSource.getXAConnection(user, password), maxStatements);
    }

    private XADataSourcePooledConnection(XADataSource dataSource, XAConnection xaConnection, int maxStatements) throws SQLException {
        super(dataSource, xaConnection.getConnection(), maxStatements);
        this.xaConnection = xaConnection;
    }

    @Override
    public ConnectionEvent getConnectionEvent(SQLException sqlException) {
        return sqlException == null ? new ConnectionEvent(this) : new ConnectionEvent(this, sqlException);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this.xaConnection.getXAResource();
    }
}

