/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool;

import java.io.PrintWriter;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.PooledConnection;
import org.smallmind.persistence.sql.pool.PooledLogWriter;
import org.smallmind.quorum.pool.ComponentPoolException;

public abstract class AbstractPooledDataSource<D extends CommonDataSource, P extends PooledConnection>
implements CommonDataSource {
    private final Class<D> dataSourceClass;
    private final Class<P> pooledConnectionClass;
    private final PrintWriter logWriter;

    public AbstractPooledDataSource(Class<D> dataSourceClass, Class<P> pooledConnectionClass) {
        this.dataSourceClass = dataSourceClass;
        this.pooledConnectionClass = pooledConnectionClass;
        this.logWriter = new PrintWriter(new PooledLogWriter());
    }

    public abstract void startup() throws ComponentPoolException;

    public abstract void shutdown() throws ComponentPoolException;

    public Class<D> getDataSourceClass() {
        return this.dataSourceClass;
    }

    public Class<P> getPooledConnectionClass() {
        return this.pooledConnectionClass;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        throw new UnsupportedOperationException("Please properly configure the underlying pool which is represented by this DataSource");
    }

    @Override
    public int getLoginTimeout() {
        throw new UnsupportedOperationException("Please properly configure the underlying resource managed by the pool which is represented by this DataSource");
    }

    @Override
    public void setLoginTimeout(int seconds) {
        throw new UnsupportedOperationException("Please properly configure the underlying resource managed by the pool which is represented by this DataSource");
    }

    public boolean isWrapperFor(Class<?> clazz) {
        return false;
    }

    public <T> T unwrap(Class<T> clazz) {
        throw new UnsupportedOperationException("This DataSource represents a connection pool");
    }
}

