/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool;

import java.lang.reflect.Array;
import java.sql.SQLException;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.smallmind.persistence.sql.OmnivorousConnectionPoolDataSource;
import org.smallmind.persistence.sql.pool.ConnectionEndpoint;
import org.smallmind.persistence.sql.pool.DataSourceFactory;
import org.smallmind.persistence.sql.pool.PooledConnectionComponentInstanceFactory;

public class DataSourceComponentInstanceFactory<D extends CommonDataSource, P extends PooledConnection>
extends PooledConnectionComponentInstanceFactory<P> {
    public DataSourceComponentInstanceFactory(DataSourceFactory<D, P> dataSourceFactory, String jdbcUrl, String user, String password) throws SQLException {
        this(dataSourceFactory, jdbcUrl, user, password, 0);
    }

    public DataSourceComponentInstanceFactory(DataSourceFactory<D, P> dataSourceFactory, String jdbcUrl, String user, String password, int maxStatements) throws SQLException {
        this(dataSourceFactory, maxStatements, new ConnectionEndpoint(jdbcUrl, user, password));
    }

    public DataSourceComponentInstanceFactory(DataSourceFactory<D, P> dataSourceFactory, ConnectionEndpoint ... endpoints) throws SQLException {
        this(dataSourceFactory, 0, endpoints);
    }

    public DataSourceComponentInstanceFactory(DataSourceFactory<D, P> dataSourceFactory, int maxStatements, ConnectionEndpoint ... endpoints) throws SQLException {
        this(maxStatements, dataSourceFactory.getPooledConnectionClass(), DataSourceComponentInstanceFactory.constructDataSources(dataSourceFactory, (ConnectionEndpoint[])endpoints));
    }

    public DataSourceComponentInstanceFactory(int maxStatements, Class<P> pooledConnectionClass, D ... dataSources) {
        super(60, pooledConnectionClass, DataSourceComponentInstanceFactory.constructConnectionPoolDataSources((int)maxStatements, pooledConnectionClass, dataSources));
    }

    private static <D extends CommonDataSource, P extends PooledConnection> D[] constructDataSources(DataSourceFactory<D, P> dataSourceFactory, ConnectionEndpoint ... endpoints) throws SQLException {
        CommonDataSource[] dataSources = (CommonDataSource[])Array.newInstance(dataSourceFactory.getDataSourceClass(), endpoints.length);
        int index = 0;
        while (index < endpoints.length) {
            dataSources[index] = dataSourceFactory.constructDataSource(endpoints[index].getJdbcUrl(), endpoints[index].getUser(), endpoints[index].getPassword());
            ++index;
        }
        return dataSources;
    }

    private static <D extends CommonDataSource, P extends PooledConnection> ConnectionPoolDataSource[] constructConnectionPoolDataSources(int maxStatements, Class<P> connectionPoolClass, D ... dataSources) {
        ConnectionPoolDataSource[] connectionPoolDataSources = new ConnectionPoolDataSource[dataSources.length];
        int index = 0;
        while (index < dataSources.length) {
            connectionPoolDataSources[index] = new OmnivorousConnectionPoolDataSource<D, P>(dataSources[index], connectionPoolClass, maxStatements);
            ++index;
        }
        return connectionPoolDataSources;
    }
}

