/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool;

import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.smallmind.persistence.sql.DriverManagerDataSource;
import org.smallmind.persistence.sql.OmnivorousConnectionPoolDataSource;
import org.smallmind.persistence.sql.pool.ConnectionEndpoint;
import org.smallmind.persistence.sql.pool.PooledConnectionComponentInstanceFactory;

public class DriverManagerComponentInstanceFactory
extends PooledConnectionComponentInstanceFactory {
    public DriverManagerComponentInstanceFactory(String driverClassName, String jdbcUrl, String user, String password) throws SQLException {
        this(driverClassName, jdbcUrl, user, password, 0);
    }

    public DriverManagerComponentInstanceFactory(String driverClassName, String jdbcUrl, String user, String password, int maxStatements) throws SQLException {
        this(driverClassName, maxStatements, new ConnectionEndpoint(jdbcUrl, user, password));
    }

    public DriverManagerComponentInstanceFactory(String driverClassName, ConnectionEndpoint ... endpoints) throws SQLException {
        this(driverClassName, 0, endpoints);
    }

    public DriverManagerComponentInstanceFactory(String driverClassName, int maxStatements, ConnectionEndpoint ... endpoints) throws SQLException {
        this(maxStatements, DriverManagerComponentInstanceFactory.constructDataSources(driverClassName, endpoints));
    }

    public DriverManagerComponentInstanceFactory(int maxStatements, DriverManagerDataSource ... dataSources) {
        super(60, PooledConnection.class, DriverManagerComponentInstanceFactory.constructConnectionPoolDataSources(maxStatements, dataSources));
    }

    private static DriverManagerDataSource[] constructDataSources(String driverClassName, ConnectionEndpoint ... endpoints) throws SQLException {
        DriverManagerDataSource[] dataSources = new DriverManagerDataSource[endpoints.length];
        int index = 0;
        while (index < endpoints.length) {
            dataSources[index] = new DriverManagerDataSource(driverClassName, endpoints[index].getJdbcUrl(), endpoints[index].getUser(), endpoints[index].getPassword());
            ++index;
        }
        return dataSources;
    }

    private static ConnectionPoolDataSource[] constructConnectionPoolDataSources(int maxStatements, DriverManagerDataSource ... dataSources) {
        ConnectionPoolDataSource[] connectionPoolDataSources = new ConnectionPoolDataSource[dataSources.length];
        int index = 0;
        while (index < dataSources.length) {
            connectionPoolDataSources[index] = new OmnivorousConnectionPoolDataSource<DriverManagerDataSource, PooledConnection>(dataSources[index], PooledConnection.class, maxStatements);
            ++index;
        }
        return connectionPoolDataSources;
    }
}

