/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.smallmind.quorum.pool.complex.ComponentInstance;
import org.smallmind.quorum.pool.complex.ComponentPool;
import org.smallmind.scribe.pen.LoggerManager;

public class PooledConnectionComponentInstance<P extends PooledConnection>
implements ComponentInstance<P>,
ConnectionEventListener {
    private final ComponentPool<P> componentPool;
    private final P pooledConnection;
    private final AtomicReference<StackTraceElement[]> stackTraceReference = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private PreparedStatement validationStatement;

    public PooledConnectionComponentInstance(ComponentPool<P> componentPool, P pooledConnection) throws SQLException {
        this.componentPool = componentPool;
        this.pooledConnection = pooledConnection;
        pooledConnection.addConnectionEventListener(this);
    }

    public PooledConnectionComponentInstance(ComponentPool<P> componentPool, P pooledConnection, String validationQuery) throws SQLException {
        this(componentPool, pooledConnection);
        this.validationStatement = validationQuery != null && validationQuery.length() > 0 ? pooledConnection.getConnection().prepareStatement(validationQuery) : null;
    }

    public StackTraceElement[] getExistentialStackTrace() {
        return this.stackTraceReference.get();
    }

    public boolean validate() {
        if (this.validationStatement != null) {
            try {
                this.validationStatement.execute();
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            this.componentPool.returnInstance((ComponentInstance)this);
        }
        catch (Exception exception) {
            LoggerManager.getLogger(PooledConnectionComponentInstance.class).error((Throwable)exception);
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        SQLException reportedException = connectionEvent.getSQLException();
        try {
            try {
                if (reportedException != null) {
                    this.componentPool.reportErrorOccurred((Exception)reportedException);
                }
            }
            catch (Exception exception) {
                LoggerManager.getLogger(PooledConnectionComponentInstance.class).error((Throwable)exception);
                try {
                    this.componentPool.terminateInstance((ComponentInstance)this);
                }
                catch (Exception exception2) {
                    if (reportedException != null && exception2.getCause() == exception2) {
                        exception2.initCause(reportedException);
                    }
                    LoggerManager.getLogger(PooledConnectionComponentInstance.class).error((Throwable)exception2);
                }
            }
        }
        finally {
            try {
                this.componentPool.terminateInstance((ComponentInstance)this);
            }
            catch (Exception exception) {
                if (reportedException != null && exception.getCause() == exception) {
                    exception.initCause(reportedException);
                }
                LoggerManager.getLogger(PooledConnectionComponentInstance.class).error((Throwable)exception);
            }
        }
    }

    public P serve() {
        if (this.componentPool.getComplexPoolConfig().isExistentiallyAware()) {
            this.stackTraceReference.set(Thread.currentThread().getStackTrace());
        }
        return this.pooledConnection;
    }

    public void close() throws SQLException {
        if (this.closed.compareAndSet(false, true)) {
            SQLException validationCloseException = null;
            if (this.componentPool.getComplexPoolConfig().isExistentiallyAware()) {
                this.stackTraceReference.set(null);
            }
            if (this.validationStatement != null) {
                try {
                    this.validationStatement.close();
                }
                catch (SQLException sqlException) {
                    validationCloseException = sqlException;
                }
            }
            if (this.pooledConnection != null) {
                try {
                    try {
                        this.pooledConnection.close();
                    }
                    catch (SQLException sqlException) {
                        if (validationCloseException != null && sqlException.getCause() != sqlException) {
                            sqlException.initCause(validationCloseException);
                        }
                        throw sqlException;
                    }
                }
                finally {
                    this.pooledConnection.removeConnectionEventListener(this);
                }
            }
            if (validationCloseException != null) {
                throw validationCloseException;
            }
        }
    }
}

