/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool;

import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.smallmind.quorum.juggler.AbstractJugglingPin;
import org.smallmind.quorum.juggler.JugglerResourceException;

public class PooledConnectionJugglingPin<P extends PooledConnection>
extends AbstractJugglingPin<P> {
    private ConnectionPoolDataSource dataSource;
    private Class<P> pooledConnectionClass;

    public PooledConnectionJugglingPin(ConnectionPoolDataSource dataSource, Class<P> pooledConnectionClass) {
        this.dataSource = dataSource;
        this.pooledConnectionClass = pooledConnectionClass;
    }

    public P obtain() throws JugglerResourceException {
        try {
            return (P)((PooledConnection)this.pooledConnectionClass.cast(this.dataSource.getPooledConnection()));
        }
        catch (SQLException sqlException) {
            throw new JugglerResourceException((Throwable)sqlException);
        }
    }

    public boolean recover() {
        try {
            this.dataSource.getPooledConnection().close();
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public String describe() {
        return this.dataSource.toString();
    }
}

