/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.smallmind.persistence.sql.DataSourceManager;
import org.smallmind.persistence.sql.pool.AbstractPooledDataSource;
import org.smallmind.quorum.pool.ComponentPoolException;
import org.smallmind.quorum.pool.complex.ComponentPool;

public class PooledDataSource
extends AbstractPooledDataSource<DataSource, PooledConnection>
implements DataSource {
    private ComponentPool<PooledConnection> componentPool;
    private String key;

    public PooledDataSource(ComponentPool<PooledConnection> componentPool) {
        this(componentPool.getPoolName(), componentPool);
    }

    public PooledDataSource(String key, ComponentPool<PooledConnection> componentPool) {
        super(DataSource.class, PooledConnection.class);
        this.key = key;
        this.componentPool = componentPool;
    }

    public void register() {
        DataSourceManager.register(this.key, this);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return ((PooledConnection)this.componentPool.getComponent()).getConnection();
        }
        catch (ComponentPoolException componentPoolException) {
            throw new SQLException(componentPoolException);
        }
    }

    @Override
    public Connection getConnection(String username, String password) {
        throw new UnsupportedOperationException("Please properly configure the underlying resource managed by the pool which is represented by this DataSource");
    }

    @Override
    public void startup() throws ComponentPoolException {
        this.componentPool.startup();
    }

    @Override
    public void shutdown() throws ComponentPoolException {
        this.componentPool.shutdown();
    }
}

