/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool;

import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.smallmind.persistence.sql.DataSourceManager;
import org.smallmind.persistence.sql.pool.AbstractPooledDataSource;
import org.smallmind.quorum.pool.ComponentPoolException;
import org.smallmind.quorum.pool.complex.ComponentPool;

public class XAPooledDataSource
extends AbstractPooledDataSource<XADataSource, XAConnection>
implements XADataSource {
    private ComponentPool<XAConnection> componentPool;
    private String key;

    public XAPooledDataSource(ComponentPool<XAConnection> componentPool) {
        this(componentPool.getPoolName(), componentPool);
    }

    public XAPooledDataSource(String key, ComponentPool<XAConnection> componentPool) {
        super(XADataSource.class, XAConnection.class);
        this.key = key;
        this.componentPool = componentPool;
    }

    public void register() {
        DataSourceManager.register(this.key, this);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        try {
            return (XAConnection)this.componentPool.getComponent();
        }
        catch (ComponentPoolException componentPoolException) {
            throw new SQLException(componentPoolException);
        }
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        throw new UnsupportedOperationException("Please properly configure the underlying resource managed by the pool which is represented by this DataSource");
    }

    @Override
    public void startup() throws ComponentPoolException {
        this.componentPool.startup();
    }

    @Override
    public void shutdown() throws ComponentPoolException {
        this.componentPool.shutdown();
    }
}

