/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool.context;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.smallmind.nutsnbolts.context.ContextFactory;
import org.smallmind.persistence.sql.pool.AbstractPooledDataSource;
import org.smallmind.persistence.sql.pool.context.ContextualPoolNameTranslator;
import org.smallmind.persistence.sql.pool.context.PooledDataSourceContext;
import org.smallmind.quorum.pool.ComponentPoolException;
import org.smallmind.quorum.pool.complex.ComponentPool;

public class ContextualPooledDataSource
extends AbstractPooledDataSource<DataSource, PooledConnection>
implements DataSource {
    private final HashMap<String, ComponentPool<? extends PooledConnection>> componentPoolMap = new HashMap();
    private final String baseName;

    public ContextualPooledDataSource(ContextualPoolNameTranslator poolNameTranslator, ComponentPool<? extends PooledConnection> ... componentPools) throws ComponentPoolException {
        super(DataSource.class, PooledConnection.class);
        this.baseName = poolNameTranslator.getBaseName();
        ComponentPool<? extends PooledConnection>[] componentPoolArray = componentPools;
        int n = componentPools.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentPool<? extends PooledConnection> componentPool = componentPoolArray[n2];
            this.componentPoolMap.put(poolNameTranslator.getContextualPartFromPoolName(componentPool.getPoolName()), componentPool);
            ++n2;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            PooledDataSourceContext pooledDataSourceContext = (PooledDataSourceContext)ContextFactory.getContext(PooledDataSourceContext.class);
            String contextualPart = pooledDataSourceContext == null ? null : pooledDataSourceContext.getContextualPart();
            ComponentPool<? extends PooledConnection> componentPool = this.componentPoolMap.get(contextualPart);
            if (componentPool == null) {
                throw new ComponentPoolException("Unable to locate component pool for base name(%s) and context(%s)", new Object[]{this.baseName, contextualPart == null ? "null" : contextualPart});
            }
            return ((PooledConnection)componentPool.getComponent()).getConnection();
        }
        catch (ComponentPoolException componentPoolException) {
            throw new SQLException(componentPoolException);
        }
    }

    @Override
    public Connection getConnection(String username, String password) {
        throw new UnsupportedOperationException("Please properly configure the underlying resource managed by the pool which is represented by this DataSource");
    }

    @Override
    public void startup() throws ComponentPoolException {
        for (ComponentPool<? extends PooledConnection> componentPool : this.componentPoolMap.values()) {
            componentPool.startup();
        }
    }

    @Override
    public void shutdown() throws ComponentPoolException {
        for (ComponentPool<? extends PooledConnection> componentPool : this.componentPoolMap.values()) {
            componentPool.shutdown();
        }
    }
}

