/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool.context;

import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.smallmind.nutsnbolts.context.ContextFactory;
import org.smallmind.persistence.sql.pool.AbstractPooledDataSource;
import org.smallmind.persistence.sql.pool.context.ContextualPoolNameTranslator;
import org.smallmind.persistence.sql.pool.context.PooledDataSourceContext;
import org.smallmind.quorum.pool.ComponentPoolException;
import org.smallmind.quorum.pool.complex.ComponentPool;

public class ContextualXAPooledDataSource
extends AbstractPooledDataSource<XADataSource, XAConnection>
implements XADataSource {
    private final HashMap<String, ComponentPool<XAConnection>> componentPoolMap = new HashMap();
    private final String baseName;

    public ContextualXAPooledDataSource(ContextualPoolNameTranslator poolNameTranslator, ComponentPool<XAConnection> ... componentPools) throws ComponentPoolException {
        super(XADataSource.class, XAConnection.class);
        this.baseName = poolNameTranslator.getBaseName();
        ComponentPool<XAConnection>[] componentPoolArray = componentPools;
        int n = componentPools.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentPool<XAConnection> componentPool = componentPoolArray[n2];
            this.componentPoolMap.put(poolNameTranslator.getContextualPartFromPoolName(componentPool.getPoolName()), componentPool);
            ++n2;
        }
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        try {
            PooledDataSourceContext pooledDataSourceContext = (PooledDataSourceContext)ContextFactory.getContext(PooledDataSourceContext.class);
            String contextualPart = pooledDataSourceContext == null ? null : pooledDataSourceContext.getContextualPart();
            ComponentPool<XAConnection> componentPool = this.componentPoolMap.get(contextualPart);
            if (componentPool == null) {
                throw new ComponentPoolException("Unable to locate component pool for base name(%s) and context(%s)", new Object[]{this.baseName, contextualPart == null ? "null" : contextualPart});
            }
            return (XAConnection)componentPool.getComponent();
        }
        catch (ComponentPoolException componentPoolException) {
            throw new SQLException(componentPoolException);
        }
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        throw new UnsupportedOperationException("Please properly configure the underlying resource managed by the pool which is represented by this DataSource");
    }

    @Override
    public void startup() throws ComponentPoolException {
        for (ComponentPool<XAConnection> componentPool : this.componentPoolMap.values()) {
            componentPool.startup();
        }
    }

    @Override
    public void shutdown() throws ComponentPoolException {
        for (ComponentPool<XAConnection> componentPool : this.componentPoolMap.values()) {
            componentPool.shutdown();
        }
    }
}

