/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool.context;

import org.smallmind.persistence.sql.pool.context.ContextualPoolNameTranslator;
import org.smallmind.quorum.pool.ComponentPoolException;

public class DefaultContextualPoolNameTranslator
implements ContextualPoolNameTranslator {
    private String baseName;
    private char separator;

    public DefaultContextualPoolNameTranslator(String baseName, char separator) {
        this.baseName = baseName;
        this.separator = separator;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public String getPoolName(String contextualPart) {
        return String.valueOf(this.baseName) + this.separator + contextualPart;
    }

    @Override
    public String getContextualPartFromPoolName(String poolName) throws ComponentPoolException {
        if (!poolName.startsWith(this.baseName)) {
            throw new ComponentPoolException("Unable to parse pool name(%s)", new Object[]{poolName});
        }
        if (poolName.length() == this.baseName.length()) {
            return null;
        }
        if (poolName.charAt(this.baseName.length()) != this.separator) {
            throw new ComponentPoolException("Unable to parse pool name(%s)", new Object[]{poolName});
        }
        return poolName.substring(this.baseName.length() + 1);
    }
}

