/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool.spring;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.CommonDataSource;
import org.smallmind.nutsnbolts.spring.RuntimeBeansException;
import org.smallmind.nutsnbolts.spring.SpringPropertyAccessor;
import org.smallmind.nutsnbolts.spring.SpringPropertyAccessorManager;
import org.smallmind.nutsnbolts.util.Option;
import org.smallmind.persistence.sql.pool.AbstractPooledDataSource;
import org.smallmind.persistence.sql.pool.DataSourceFactory;
import org.smallmind.persistence.sql.pool.PooledDataSourceFactory;
import org.smallmind.persistence.sql.pool.context.ContextualPooledDataSource;
import org.smallmind.persistence.sql.pool.context.DefaultContextualPoolNameTranslator;
import org.smallmind.persistence.sql.pool.spring.ContextIndex;
import org.smallmind.persistence.sql.pool.spring.DataSourceLocator;
import org.smallmind.persistence.sql.pool.spring.DatabaseConnection;
import org.smallmind.persistence.sql.pool.spring.PooledConnectionComponentPoolFactory;
import org.smallmind.quorum.pool.ComponentPoolException;
import org.smallmind.quorum.pool.complex.ComplexPoolConfig;
import org.smallmind.quorum.pool.complex.ComponentPool;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DynamicPooledDataSourceInitializingBean
implements InitializingBean,
DisposableBean,
DataSourceLocator {
    private final HashMap<String, AbstractPooledDataSource> dataSourceMap = new HashMap();
    private final HashMap<String, String> poolNameMap = new HashMap();
    private Map<String, DataSourceFactory<?, ?>> factoryMap;
    private String prefix;

    public void setFactoryMap(Map<String, DataSourceFactory<?, ?>> factoryMap) {
        this.factoryMap = factoryMap;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix == null ? null : prefix.trim();
    }

    @Override
    public CommonDataSource getDataSource(String dataSourceKey) {
        String poolName = this.poolNameMap.get(dataSourceKey);
        if (poolName == null) {
            throw new RuntimeBeansException("No mapping definition was provided for data source key(%s)", new Object[]{dataSourceKey});
        }
        CommonDataSource dataSource = this.dataSourceMap.get(poolName);
        if (dataSource == null) {
            throw new RuntimeBeansException("No connection pool(%s) definition exists for data source key(%s)", new Object[]{poolName, dataSourceKey});
        }
        return dataSource;
    }

    public void afterPropertiesSet() throws SQLException, ComponentPoolException {
        SpringPropertyAccessor springPropertyAccessor = SpringPropertyAccessorManager.getSpringPropertyAccessor();
        this.prefix = this.prefix == null || this.prefix.isEmpty() ? "" : String.valueOf(this.prefix) + ".";
        for (String poolName : this.factoryMap.keySet()) {
            this.dataSourceMap.put(poolName, this.parsePoolDefinition(springPropertyAccessor, poolName));
        }
        for (String key : springPropertyAccessor.getKeySet()) {
            String dataSourceKey;
            String mappingKey;
            if (!key.startsWith(mappingKey = String.valueOf(this.prefix) + "jdbc.mapping.") || (dataSourceKey = key.substring(mappingKey.length())).contains(".")) continue;
            String poolName = springPropertyAccessor.asString(String.valueOf(mappingKey) + dataSourceKey);
            this.poolNameMap.put(dataSourceKey, poolName);
            if (this.dataSourceMap.containsKey(poolName)) continue;
            throw new RuntimeBeansException("No connection pool(%s) definition exists for data source key(%s)", new Object[]{poolName, dataSourceKey});
        }
        for (AbstractPooledDataSource dataSource : this.dataSourceMap.values()) {
            dataSource.startup();
        }
    }

    public void destroy() throws ComponentPoolException {
        for (AbstractPooledDataSource dataSource : this.dataSourceMap.values()) {
            dataSource.shutdown();
        }
    }

    private AbstractPooledDataSource parsePoolDefinition(SpringPropertyAccessor springPropertyAccessor, String poolName) throws SQLException, ComponentPoolException {
        Option maxLeaseTimeSecondsOption;
        Option maxIdleSecondsOption;
        Option connectionTimeoutMillisOption;
        Option acquireWaitTimeMillisOption;
        Option maxSizeOption;
        Option minSizeOption;
        Option initialSizeOption;
        Option testOnAcquireOption;
        ComplexPoolConfig complexPoolConfig = new ComplexPoolConfig();
        HashMap<String, HashMap<Integer, DatabaseConnection>> preContextMap = new HashMap<String, HashMap<Integer, DatabaseConnection>>();
        HashMap<String, DatabaseConnection[]> postContextMap = new HashMap<String, DatabaseConnection[]>();
        String urlPrefix = String.valueOf(this.prefix) + "jdbc.url." + poolName + ".";
        String userPrefix = String.valueOf(this.prefix) + "jdbc.user." + poolName + ".";
        String passwordPrefix = String.valueOf(this.prefix) + "jdbc.password." + poolName + ".";
        for (String string : springPropertyAccessor.getKeySet()) {
            if (string.startsWith(urlPrefix)) {
                this.getDatabaseConnection(preContextMap, this.getContextIndex(string.substring(urlPrefix.length()))).setJdbcUrl(springPropertyAccessor.asString(string));
            }
            if (string.startsWith(userPrefix)) {
                this.getDatabaseConnection(preContextMap, this.getContextIndex(string.substring(userPrefix.length()))).setUser(springPropertyAccessor.asString(string));
            }
            if (!string.startsWith(passwordPrefix)) continue;
            this.getDatabaseConnection(preContextMap, this.getContextIndex(string.substring(passwordPrefix.length()))).setPassword(springPropertyAccessor.asString(string));
        }
        if (preContextMap.isEmpty()) {
            throw new RuntimeBeansException("Database connection pool(%s) has no defined connections", new Object[]{poolName});
        }
        if (preContextMap.size() == 1 && !preContextMap.containsKey(null)) {
            throw new RuntimeBeansException("Database connection pool(%s) has only a single defined context, so should be defined without any context at all", new Object[]{poolName});
        }
        for (Map.Entry entry : preContextMap.entrySet()) {
            HashMap connectionMap = (HashMap)entry.getValue();
            LinkedList<DatabaseConnection> connectionList = new LinkedList<DatabaseConnection>();
            int index = 0;
            while (!connectionMap.isEmpty()) {
                DatabaseConnection connection;
                if ((connection = (DatabaseConnection)connectionMap.remove(index++)) == null) {
                    if (entry.getKey() == null) {
                        throw new RuntimeBeansException("Database connection pool(%s) is missing a connection definition at index(%d)", new Object[]{poolName, index - 1});
                    }
                    throw new RuntimeBeansException("Database connection pool(%s) at context(%s) is missing a connection definition at index(%d)", new Object[]{poolName, entry.getKey(), index - 1});
                }
                if (!connection.isComplete()) {
                    if (entry.getKey() == null) {
                        throw new RuntimeBeansException("Database connection pool(%s) has an incomplete connection definition at index(%d)", new Object[]{poolName, index - 1});
                    }
                    throw new RuntimeBeansException("Database connection pool(%s) at context(%s) has an incomplete connection definition at index(%d)", new Object[]{poolName, entry.getKey(), index - 1});
                }
                connectionList.add(connection);
            }
            DatabaseConnection[] connections = new DatabaseConnection[connectionList.size()];
            connectionList.toArray(connections);
            postContextMap.put((String)entry.getKey(), connections);
        }
        Option maxStatementsOption = springPropertyAccessor.asInt(String.valueOf(this.prefix) + "jdbc.max_statements." + poolName);
        String validationQuery = springPropertyAccessor.asString(String.valueOf(this.prefix) + "jdbc.validation_query." + poolName);
        Option testOnCreateOption = springPropertyAccessor.asBoolean(String.valueOf(this.prefix) + "jdbc.pool.test_on_create." + poolName);
        if (!testOnCreateOption.isNone()) {
            complexPoolConfig.setTestOnCreate(((Boolean)testOnCreateOption.get()).booleanValue());
        }
        if (!(testOnAcquireOption = springPropertyAccessor.asBoolean(String.valueOf(this.prefix) + "jdbc.pool.test_on_acquire." + poolName)).isNone()) {
            complexPoolConfig.setTestOnAcquire(((Boolean)testOnAcquireOption.get()).booleanValue());
        }
        if (!(initialSizeOption = springPropertyAccessor.asInt(String.valueOf(this.prefix) + "jdbc.pool.initial_size." + poolName)).isNone()) {
            complexPoolConfig.setInitialPoolSize(((Integer)initialSizeOption.get()).intValue());
        }
        if (!(minSizeOption = springPropertyAccessor.asInt(String.valueOf(this.prefix) + "jdbc.pool.min_size." + poolName)).isNone()) {
            complexPoolConfig.setMinPoolSize(((Integer)minSizeOption.get()).intValue());
        }
        if (!(maxSizeOption = springPropertyAccessor.asInt(String.valueOf(this.prefix) + "jdbc.pool.max_size." + poolName)).isNone()) {
            complexPoolConfig.setMaxPoolSize(((Integer)maxSizeOption.get()).intValue());
        }
        if (!(acquireWaitTimeMillisOption = springPropertyAccessor.asLong(String.valueOf(this.prefix) + "jdbc.pool.acquire_wait_time_millis." + poolName)).isNone()) {
            complexPoolConfig.setAcquireWaitTimeMillis(((Long)acquireWaitTimeMillisOption.get()).longValue());
        }
        if (!(connectionTimeoutMillisOption = springPropertyAccessor.asLong(String.valueOf(this.prefix) + "jdbc.pool.connection_timeout_millis." + poolName)).isNone()) {
            complexPoolConfig.setCreationTimeoutMillis(((Long)connectionTimeoutMillisOption.get()).longValue());
        }
        if (!(maxIdleSecondsOption = springPropertyAccessor.asInt(String.valueOf(this.prefix) + "jdbc.pool.max_idle_seconds." + poolName)).isNone()) {
            complexPoolConfig.setMaxIdleTimeSeconds(((Integer)maxIdleSecondsOption.get()).intValue());
        }
        if (!(maxLeaseTimeSecondsOption = springPropertyAccessor.asInt(String.valueOf(this.prefix) + "jdbc.pool.max_lease_time_seconds." + poolName)).isNone()) {
            complexPoolConfig.setMaxLeaseTimeSeconds(((Integer)maxLeaseTimeSecondsOption.get()).intValue());
        }
        if (postContextMap.size() == 1) {
            return PooledDataSourceFactory.createPooledDataSource(poolName, this.factoryMap.get(poolName), validationQuery, maxStatementsOption.isNone() ? 0 : (Integer)maxStatementsOption.get(), complexPoolConfig, (DatabaseConnection[])postContextMap.get(null));
        }
        ComponentPool[] componentPoolArray = new ComponentPool[postContextMap.size()];
        DefaultContextualPoolNameTranslator poolNameTranslator = new DefaultContextualPoolNameTranslator(poolName, ':');
        int index = 0;
        for (Map.Entry contextEntry : postContextMap.entrySet()) {
            componentPoolArray[index++] = PooledConnectionComponentPoolFactory.constructComponentPool(poolNameTranslator.getPoolName((String)contextEntry.getKey()), this.factoryMap.get(poolName), validationQuery, maxStatementsOption.isNone() ? 0 : (Integer)maxStatementsOption.get(), complexPoolConfig, (DatabaseConnection[])contextEntry.getValue());
        }
        return new ContextualPooledDataSource(poolNameTranslator, componentPoolArray);
    }

    private ContextIndex getContextIndex(String subKey) {
        int periodPos = subKey.indexOf(46);
        if (periodPos < 0) {
            return new ContextIndex(null, Integer.parseInt(subKey));
        }
        return new ContextIndex(subKey.substring(0, periodPos), Integer.parseInt(subKey.substring(periodPos + 1)));
    }

    private DatabaseConnection getDatabaseConnection(HashMap<String, HashMap<Integer, DatabaseConnection>> contextMap, ContextIndex contextIndex) {
        DatabaseConnection databaseConnection;
        HashMap<Integer, DatabaseConnection> connectionMap = contextMap.get(contextIndex.getContext());
        if (connectionMap == null) {
            connectionMap = new HashMap();
            contextMap.put(contextIndex.getContext(), connectionMap);
        }
        if ((databaseConnection = connectionMap.get(contextIndex.getIndex())) == null) {
            databaseConnection = new DatabaseConnection();
            connectionMap.put(contextIndex.getIndex(), databaseConnection);
        }
        return databaseConnection;
    }
}

