/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool.spring;

import java.sql.SQLException;
import javax.sql.CommonDataSource;
import javax.sql.PooledConnection;
import org.smallmind.persistence.sql.pool.ConnectionEndpoint;
import org.smallmind.persistence.sql.pool.DataSourceComponentInstanceFactory;
import org.smallmind.persistence.sql.pool.DataSourceFactory;
import org.smallmind.persistence.sql.pool.spring.DatabaseConnection;
import org.smallmind.quorum.pool.ComponentPoolException;
import org.smallmind.quorum.pool.complex.ComplexPoolConfig;
import org.smallmind.quorum.pool.complex.ComponentPool;

public class PooledConnectionComponentPoolFactory {
    public static <D extends CommonDataSource> ComponentPool<? extends PooledConnection> constructComponentPool(String poolName, DataSourceFactory<D, ? extends PooledConnection> dataSourceFactory, String validationQuery, int maxStatements, ComplexPoolConfig poolConfig, DatabaseConnection ... connections) throws SQLException, ComponentPoolException {
        DataSourceComponentInstanceFactory<D, PooledConnection> connectionInstanceFactory = new DataSourceComponentInstanceFactory<D, PooledConnection>(dataSourceFactory, maxStatements, PooledConnectionComponentPoolFactory.createConnectionEndpoints(connections));
        if (validationQuery != null) {
            connectionInstanceFactory.setValidationQuery(validationQuery);
        }
        return new ComponentPool(poolName, connectionInstanceFactory).setComplexPoolConfig(poolConfig);
    }

    private static ConnectionEndpoint[] createConnectionEndpoints(DatabaseConnection ... databaseConnections) {
        if (databaseConnections == null) {
            return new ConnectionEndpoint[0];
        }
        ConnectionEndpoint[] connectionEndpoints = new ConnectionEndpoint[databaseConnections.length];
        int count = 0;
        while (count < connectionEndpoints.length) {
            connectionEndpoints[count] = new ConnectionEndpoint(databaseConnections[count].getJdbcUrl(), databaseConnections[count].getUser(), databaseConnections[count].getPassword());
            ++count;
        }
        return connectionEndpoints;
    }
}

