/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence.sql.pool.spring;

import java.sql.SQLException;
import javax.sql.CommonDataSource;
import javax.sql.PooledConnection;
import org.smallmind.persistence.sql.pool.AbstractPooledDataSource;
import org.smallmind.persistence.sql.pool.DataSourceFactory;
import org.smallmind.persistence.sql.pool.PooledDataSourceFactory;
import org.smallmind.persistence.sql.pool.spring.DatabaseConnection;
import org.smallmind.quorum.pool.ComponentPoolException;
import org.smallmind.quorum.pool.complex.ComplexPoolConfig;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class PooledDataSourceFactoryBean<D extends CommonDataSource, P extends PooledConnection>
implements FactoryBean<CommonDataSource>,
InitializingBean,
DisposableBean {
    private AbstractPooledDataSource dataSource;
    private DataSourceFactory<D, P> dataSourceFactory;
    private ComplexPoolConfig poolConfig;
    private DatabaseConnection[] connections;
    private String poolName;
    private String validationQuery;
    private int maxStatements;

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setDataSourceFactory(DataSourceFactory<D, P> dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public void setConnections(DatabaseConnection[] connections) {
        this.connections = connections;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    public void setPoolConfig(ComplexPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    public void afterPropertiesSet() throws SQLException, ComponentPoolException {
        this.dataSource = PooledDataSourceFactory.createPooledDataSource(this.poolName, this.dataSourceFactory, this.validationQuery, this.maxStatements, this.poolConfig, this.connections);
        this.dataSource.startup();
    }

    public void destroy() throws ComponentPoolException {
        this.dataSource.shutdown();
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return CommonDataSource.class;
    }

    public CommonDataSource getObject() {
        return this.dataSource;
    }
}

