/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.spark.singularity.boot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class CachedJarFile {
    private final HashMap<String, byte[]> entryMap = new HashMap();
    private final String entryName;

    public CachedJarFile(String entryName, JarInputStream jarInputStream) throws IOException {
        JarEntry innerJarEntry;
        byte[] buffer = new byte[8192];
        this.entryName = entryName;
        while ((innerJarEntry = jarInputStream.getNextJarEntry()) != null) {
            try (ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();){
                int bytesRead;
                while ((bytesRead = jarInputStream.read(buffer)) >= 0) {
                    byteOutputStream.write(buffer, 0, bytesRead);
                }
                this.entryMap.put(innerJarEntry.getName(), byteOutputStream.toByteArray());
            }
        }
    }

    public String getEntryName() {
        return this.entryName;
    }

    public InputStream getInputStream(String name) {
        byte[] contents = this.entryMap.get(name);
        if (contents != null) {
            return new ByteArrayInputStream(contents);
        }
        return null;
    }
}

