/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.spark.singularity.boot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.smallmind.spark.singularity.boot.SingularityIndex;
import org.smallmind.spark.singularity.boot.SingularityJarURLStreamHandlerFactory;

public class SingularityClassLoader
extends ClassLoader {
    private static final PermissionCollection ALL_PERMISSION_COLLECTION;
    private static final String[] INOPERABLE_NAMESPACES;
    private static final String[] OPERABLE_NAMESPACES;
    private final HashMap<String, URL> urlMap = new HashMap();
    private final HashSet<String> packageSet = new HashSet();
    private final URL sealBase;
    private final String specificationTitle;
    private final String specificationVersion;
    private final String specificationVendor;
    private final String implementationTitle;
    private final String implementationVersion;
    private final String implementationVendor;

    public SingularityClassLoader(ClassLoader parent, Manifest manifest, URL jarURL, JarInputStream jarInputStream) throws IOException, ClassNotFoundException {
        super(parent);
        JarEntry jarEntry;
        SingularityIndex singularityIndex = null;
        Attributes mainAttributes = manifest.getMainAttributes();
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            int singleByte;
            if (jarEntry.isDirectory() || !jarEntry.getName().equals("META-INF/singularity/index/singularity.idx")) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((singleByte = jarInputStream.read()) >= 0) {
                byteArrayOutputStream.write(singleByte);
            }
            byteArrayOutputStream.close();
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
                singularityIndex = (SingularityIndex)objectInputStream.readObject();
                break;
            }
        }
        if (singularityIndex == null) {
            throw new IOException("Missing singularity index");
        }
        for (SingularityIndex.URLEntry urlEntry : singularityIndex.getJarURLEntryIterable(jarURL.toExternalForm())) {
            this.urlMap.put(urlEntry.getEntryName(), urlEntry.getEntryURL());
        }
        for (SingularityIndex.URLEntry urlEntry : singularityIndex.getSingularityURLEntryIterable(jarURL.toExternalForm())) {
            this.urlMap.put(urlEntry.getEntryName(), urlEntry.getEntryURL());
        }
        this.specificationTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
        this.specificationVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
        this.specificationVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
        this.implementationTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        this.implementationVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        this.implementationVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        String sealed = mainAttributes.getValue(Attributes.Name.SEALED);
        this.sealBase = sealed != null ? (Boolean.parseBoolean(sealed) ? jarURL : null) : null;
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> singularityClass = this.findLoadedClass(name);
        if (singularityClass == null) {
            try {
                singularityClass = this.findClass(name);
            }
            catch (ClassNotFoundException c) {
                singularityClass = this.getParent() != null ? this.getParent().loadClass(name) : this.findSystemClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(singularityClass);
        }
        return singularityClass;
    }

    @Override
    public synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        URL classURL;
        if (this.isOperableNamespace(name) && (classURL = this.urlMap.get(name.replace('.', '/') + ".class")) != null) {
            try {
                URL codeSourceUrl;
                String classURLExternalForm = classURL.toExternalForm();
                switch (classURL.getProtocol()) {
                    case "jar": {
                        int jarBangSlashIndex = classURLExternalForm.indexOf("!/");
                        if (jarBangSlashIndex < 0) {
                            codeSourceUrl = new URL(classURLExternalForm + "!/");
                            break;
                        }
                        codeSourceUrl = new URL(classURLExternalForm.substring(0, jarBangSlashIndex + 2));
                        break;
                    }
                    case "singularity": {
                        codeSourceUrl = new URL(classURLExternalForm.substring(0, classURLExternalForm.indexOf("!/")));
                        break;
                    }
                    default: {
                        throw new MalformedURLException("Unknown class url protocol(" + classURL.getProtocol() + ")");
                    }
                }
                CodeSource codeSource = new CodeSource(codeSourceUrl, (Certificate[])null);
                ProtectionDomain protectionDomain = new ProtectionDomain(codeSource, ALL_PERMISSION_COLLECTION, this, null);
                InputStream classInputStream = classURL.openStream();
                byte[] classData = this.getClassData(classInputStream);
                classInputStream.close();
                this.definePackage(name);
                return this.defineClass(name, classData, 0, classData.length, protectionDomain);
            }
            catch (Exception exception) {
                throw new ClassNotFoundException("Exception encountered while attempting to define class (" + name + ")", exception);
            }
        }
        throw new ClassNotFoundException(name);
    }

    private boolean isOperableNamespace(String name) {
        for (String operableNamespace : OPERABLE_NAMESPACES) {
            if (!name.startsWith(operableNamespace)) continue;
            return true;
        }
        for (String inoperableNamespace : INOPERABLE_NAMESPACES) {
            if (!name.startsWith(inoperableNamespace)) continue;
            return false;
        }
        return true;
    }

    private void definePackage(String name) {
        int lastDotPos = name.lastIndexOf(46);
        String packageName = name.substring(0, lastDotPos);
        if (this.packageSet.add(packageName)) {
            this.definePackage(packageName, this.specificationTitle, this.specificationVersion, this.specificationVendor, this.implementationTitle, this.implementationVersion, this.implementationVendor, this.sealBase);
        }
    }

    private byte[] getClassData(InputStream classInputStream) throws IOException {
        int singleByte;
        ByteArrayOutputStream classDataOutputStream = new ByteArrayOutputStream();
        while ((singleByte = classInputStream.read()) >= 0) {
            classDataOutputStream.write(singleByte);
        }
        return classDataOutputStream.toByteArray();
    }

    @Override
    public URL findResource(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return this.urlMap.get(name.charAt(0) == '/' ? name.substring(1) : name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        if (name == null || name.isEmpty()) {
            return Collections.emptyEnumeration();
        }
        if (!name.endsWith("/")) {
            URL url = this.findResource(name);
            if (url == null) {
                return Collections.emptyEnumeration();
            }
            return new SingleEnumeration<URL>(url);
        }
        LinkedList<URL> urlList = new LinkedList<URL>();
        for (Map.Entry<String, URL> resourceEntry : this.urlMap.entrySet()) {
            if (!resourceEntry.getKey().startsWith(name) || resourceEntry.getKey().endsWith("/")) continue;
            urlList.add(resourceEntry.getValue());
        }
        if (urlList.isEmpty()) {
            return Collections.emptyEnumeration();
        }
        URL[] urls = new URL[urlList.size()];
        urlList.toArray(urls);
        return new ArrayEnumeration<URL>(urls);
    }

    static {
        INOPERABLE_NAMESPACES = new String[]{"javax.xml.", "org.xml.", "org.w3c."};
        OPERABLE_NAMESPACES = new String[]{"javax.xml.bind."};
        AllPermission allPermission = new AllPermission();
        ALL_PERMISSION_COLLECTION = allPermission.newPermissionCollection();
        ALL_PERMISSION_COLLECTION.add(allPermission);
        ClassLoader.registerAsParallelCapable();
        URL.setURLStreamHandlerFactory(new SingularityJarURLStreamHandlerFactory());
    }

    private static class ArrayEnumeration<T>
    implements Enumeration<T> {
        private final T[] values;
        private int index = 0;

        private ArrayEnumeration(T[] values) {
            this.values = values;
        }

        @Override
        public synchronized boolean hasMoreElements() {
            return this.index < this.values.length;
        }

        @Override
        public synchronized T nextElement() {
            return this.values[this.index++];
        }
    }

    private static class SingleEnumeration<T>
    implements Enumeration<T> {
        private final T value;
        private boolean used = false;

        private SingleEnumeration(T value) {
            this.value = value;
        }

        @Override
        public synchronized boolean hasMoreElements() {
            return !this.used;
        }

        @Override
        public synchronized T nextElement() {
            if (this.used) {
                throw new NoSuchElementException();
            }
            this.used = true;
            return this.value;
        }
    }
}

