/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.spark.singularity.boot;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SingularityIndex
implements Serializable {
    private final HashMap<String, String> inverseEntryMap = new HashMap();
    private final HashSet<String> fileNameSet = new HashSet();

    public void addInverseJarEntry(String entryName, String jarName) {
        this.inverseEntryMap.put(entryName, jarName);
    }

    public void addFileName(String fileName) {
        this.fileNameSet.add(fileName);
    }

    public Iterable<URLEntry> getJarURLEntryIterable(String parentJarUrlPart) {
        return new JarURLIterator(parentJarUrlPart);
    }

    public Iterable<URLEntry> getSingularityURLEntryIterable(String parentJarUrlPart) {
        return new SingularityURLIterator(parentJarUrlPart);
    }

    public static class URLEntry {
        private final URL entryURL;
        private final String entryName;

        public URLEntry(String entryName, URL entryURL) {
            this.entryName = entryName;
            this.entryURL = entryURL;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public URL getEntryURL() {
            return this.entryURL;
        }
    }

    private class SingularityURLIterator
    implements Iterator<URLEntry>,
    Iterable<URLEntry> {
        private final Iterator<Map.Entry<String, String>> inverseEntryIter;
        private final String parentJarUrlPart;

        public SingularityURLIterator(String parentJarUrlPart) {
            this.inverseEntryIter = SingularityIndex.this.inverseEntryMap.entrySet().iterator();
            this.parentJarUrlPart = parentJarUrlPart;
        }

        @Override
        public Iterator<URLEntry> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.inverseEntryIter.hasNext();
        }

        @Override
        public URLEntry next() {
            try {
                Map.Entry<String, String> inverseEntry = this.inverseEntryIter.next();
                return new URLEntry(inverseEntry.getKey(), new URL("singularity", null, this.parentJarUrlPart + "@/META-INF/singularity/lib/" + inverseEntry.getValue() + "!/" + inverseEntry.getKey()));
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class JarURLIterator
    implements Iterator<URLEntry>,
    Iterable<URLEntry> {
        private final Iterator<String> fileNameIter;
        private final String parentJarUrlPart;

        public JarURLIterator(String parentJarUrlPart) {
            this.fileNameIter = SingularityIndex.this.fileNameSet.iterator();
            this.parentJarUrlPart = parentJarUrlPart;
        }

        @Override
        public Iterator<URLEntry> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.fileNameIter.hasNext();
        }

        @Override
        public URLEntry next() {
            try {
                String fileName = this.fileNameIter.next();
                return new URLEntry(fileName, new URL("jar", null, this.parentJarUrlPart + "!/" + fileName));
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

