/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.spark.singularity.boot;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.smallmind.spark.singularity.boot.CachedJarFile;

public class SingularityJarURLConnection
extends URLConnection {
    private static final AtomicReference<CachedJarFile> CACHED_JAR_FILE_REFERENCE = new AtomicReference();

    public SingularityJarURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        int atPos = this.url.getPath().indexOf("@/");
        if (atPos < 0) {
            throw new MalformedURLException("no @/ found in url spec:" + this.url.getPath());
        }
        JarFile jarFile = new JarFile(new URL(this.url.getPath().substring(0, atPos)).getFile());
        int bangPos = this.url.getPath().indexOf("!/", atPos + 3);
        if (bangPos < 0) {
            JarEntry jarEntry = jarFile.getJarEntry(this.url.getPath().substring(atPos + 2));
            if (jarEntry != null) {
                return jarFile.getInputStream(jarEntry);
            }
        } else {
            String outerEntryName = this.url.getPath().substring(atPos + 2, bangPos);
            String innerEntryName = this.url.getPath().substring(bangPos + 2);
            JarEntry jarEntry = jarFile.getJarEntry(outerEntryName);
            if (jarEntry != null) {
                InputStream cachedInputStream;
                CachedJarFile cachedJarFile = CACHED_JAR_FILE_REFERENCE.get();
                if (cachedJarFile == null || !cachedJarFile.getEntryName().equals(outerEntryName)) {
                    AtomicReference<CachedJarFile> atomicReference = CACHED_JAR_FILE_REFERENCE;
                    synchronized (atomicReference) {
                        cachedJarFile = CACHED_JAR_FILE_REFERENCE.get();
                        if (cachedJarFile == null || !cachedJarFile.getEntryName().equals(outerEntryName)) {
                            cachedJarFile = new CachedJarFile(outerEntryName, new JarInputStream(jarFile.getInputStream(jarEntry)));
                            CACHED_JAR_FILE_REFERENCE.set(cachedJarFile);
                        }
                    }
                }
                if ((cachedInputStream = cachedJarFile.getInputStream(innerEntryName)) != null) {
                    return cachedInputStream;
                }
            }
        }
        throw new FileNotFoundException(this.getURL().getPath());
    }

    @Override
    public int getContentLength() {
        return 0;
    }
}

