/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.spark.tanukisoft.integration;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.smallmind.nutsnbolts.lang.PerApplicationContext;
import org.smallmind.nutsnbolts.property.PropertyExpander;
import org.smallmind.nutsnbolts.util.SystemPropertyMode;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public abstract class AbstractWrapperListener
extends PerApplicationContext
implements WrapperListener {
    private static final String DEFAULT_TIMEOUT_SECONDS = "30";
    private static final int STACK_TRACE_ERROR_CODE = 2;
    private static final int MINIMUM_STARTUP_TIMEOUT_SECONDS = 10;
    private static final int FAIL_SAFE_TIMEOUT_SECONDS = 180;

    public static void main(String ... args) throws Throwable {
        if (args.length < 1) {
            throw new IllegalArgumentException(String.format("First application parameter must be the class of the %s in use", WrapperListener.class.getSimpleName()));
        }
        String startupTimeoutSeconds = WrapperManager.getProperties().getProperty("wrapper.startup.timeout");
        if (startupTimeoutSeconds != null) {
            try {
                if (Integer.parseInt(startupTimeoutSeconds) < 10) {
                    throw new IllegalStateException(String.format("The property(wrapper.startup.timeout) should be %s >= 10", 10));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException(String.format("Unable to parse the property(wrapper.startup.timeout) as in integer(%s)", startupTimeoutSeconds));
            }
        }
        String[] modifiedArgs = new String[args.length];
        modifiedArgs[0] = startupTimeoutSeconds == null ? DEFAULT_TIMEOUT_SECONDS : startupTimeoutSeconds;
        System.arraycopy(args, 1, modifiedArgs, 1, args.length - 1);
        PropertyExpander propertyExpander = new PropertyExpander(false, SystemPropertyMode.FALLBACK, true);
        for (int count = 0; count < modifiedArgs.length; ++count) {
            modifiedArgs[count] = propertyExpander.expand(modifiedArgs[count]);
        }
        WrapperManager.start((WrapperListener)((WrapperListener)Class.forName(args[0]).newInstance()), (String[])modifiedArgs);
    }

    public abstract void startup(String[] var1) throws Exception;

    public abstract void shutdown() throws Exception;

    public void controlEvent(int event) {
        if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
            WrapperManager.stop((int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer start(String[] args) {
        CountDownLatch completedLatch = new CountDownLatch(1);
        try {
            String[] trimmedArgs = new String[args.length - 1];
            int startupTimeoutSeconds = Integer.parseInt(args[0]);
            System.arraycopy(args, 1, trimmedArgs, 0, args.length - 1);
            Thread signalThread = new Thread(new SignalWorker(completedLatch, startupTimeoutSeconds));
            signalThread.setDaemon(true);
            signalThread.start();
            this.startup(trimmedArgs);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Integer n = 2;
            return n;
        }
        finally {
            completedLatch.countDown();
        }
        return null;
    }

    public int stop(int exitCode) {
        try {
            this.shutdown();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 2;
        }
        return exitCode;
    }

    private class SignalWorker
    implements Runnable {
        private CountDownLatch completedLatch;
        private int startupTimeoutSeconds;

        public SignalWorker(CountDownLatch completedLatch, int startupTimeoutSeconds) {
            this.completedLatch = completedLatch;
            this.startupTimeoutSeconds = startupTimeoutSeconds;
        }

        @Override
        public void run() {
            long startMillis = System.currentTimeMillis();
            try {
                while (System.currentTimeMillis() - startMillis < 180000L && !this.completedLatch.await(this.startupTimeoutSeconds - 2, TimeUnit.SECONDS)) {
                    WrapperManager.signalStarting((int)this.startupTimeoutSeconds);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

