/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.spark.tanukisoft.maven;

import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.smallmind.nutsnbolts.zip.CompressionType;

@Mojo(name="deploy-wrapper", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class DeployWrapperMojo
extends AbstractMojo {
    @Parameter(readonly=true, property="project")
    private MavenProject project;
    @Parameter(readonly=true, property="localRepository")
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.distributionManagementArtifactRepository}")
    private ArtifactRepository deploymentRepository;
    @Parameter(property="project.artifactId")
    private String applicationName;
    @Parameter(defaultValue="zip")
    private String compression;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactDeployer artifactDeployer;

    public void execute() throws MojoExecutionException {
        if (!this.skip) {
            CompressionType compressionType;
            try {
                compressionType = CompressionType.valueOf((String)this.compression.replace('-', '_').toUpperCase());
            }
            catch (Exception exception) {
                throw new MojoExecutionException(String.format("Unknown compression type(%s) - valid choices are %s", this.compression, Arrays.toString(CompressionType.values())), exception);
            }
            Artifact applicationArtifact = this.artifactFactory.createArtifactWithClassifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), compressionType.getExtension(), (String)(this.project.getArtifact().getClassifier() == null ? "app" : this.project.getArtifact().getClassifier() + "-app"));
            StringBuilder nameBuilder = new StringBuilder(this.applicationName).append('-').append(this.project.getVersion());
            if (this.project.getArtifact().getClassifier() != null) {
                nameBuilder.append('-');
                nameBuilder.append(this.project.getArtifact().getClassifier());
            }
            nameBuilder.append("-app").append('.').append(compressionType.getExtension());
            try {
                this.artifactDeployer.deploy(Paths.get(this.project.getBuild().getDirectory(), nameBuilder.toString()).toFile(), applicationArtifact, this.deploymentRepository, this.localRepository);
            }
            catch (ArtifactDeploymentException artifactDeploymentException) {
                throw new MojoExecutionException("Unable to deploy the application(" + this.applicationName + ")", (Exception)((Object)artifactDeploymentException));
            }
        }
    }
}

